/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nutz.castor.Castors;
import org.nutz.castor.FailToCastObjectException;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public class IocLoading {
    private Set<String> supportedTypes;

    public IocLoading(Set<String> supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    private static ObjectLoadException E(Throwable e, String fmt, Object ... args) {
        return new ObjectLoadException(String.format(fmt, args), e);
    }

    public IocObject map2iobj(Map<String, Object> map) throws ObjectLoadException {
        final IocObject iobj = new IocObject();
        if (!Iocs.isIocObject(map)) {
            for (Map.Entry<String, Object> en : map.entrySet()) {
                IocField ifld = new IocField();
                ifld.setName(en.getKey());
                ifld.setValue(this.object2value(en.getValue()));
                iobj.addField(ifld);
            }
        } else {
            Object v = map.get("type");
            try {
                String typeName = (String)v;
                if (!Strings.isBlank(typeName)) {
                    iobj.setType(Lang.loadClass(typeName));
                }
            }
            catch (Exception e) {
                throw IocLoading.E(e, "Wrong type name: '%s'", v);
            }
            try {
                v = map.get("singleton");
                if (null != v) {
                    iobj.setSingleton(Castors.me().castTo(v, Boolean.TYPE));
                }
            }
            catch (FailToCastObjectException e) {
                throw IocLoading.E(e, "Wrong singleton: '%s'", v);
            }
            v = map.get("scope");
            if (null != v) {
                iobj.setScope(v.toString());
            }
            try {
                v = map.get("events");
                if (null != v) {
                    IocEventSet ies = Lang.map2Object((Map)v, IocEventSet.class);
                    iobj.setEvents(ies);
                }
            }
            catch (Exception e) {
                throw IocLoading.E(e, "Wrong events: '%s'", v);
            }
            try {
                v = map.get("args");
                if (null != v) {
                    Lang.each(v, new Each<Object>(){

                        @Override
                        public void invoke(int i, Object ele, int length) {
                            iobj.addArg(IocLoading.this.object2value(ele));
                        }
                    });
                }
            }
            catch (Exception e) {
                throw IocLoading.E(e, "Wrong args: '%s'", v);
            }
            try {
                v = map.get("fields");
                if (null != v) {
                    Map fields = (Map)v;
                    for (Map.Entry en : fields.entrySet()) {
                        IocField ifld = new IocField();
                        ifld.setName((String)en.getKey());
                        ifld.setValue(this.object2value(en.getValue()));
                        iobj.addField(ifld);
                    }
                }
            }
            catch (Exception e) {
                throw IocLoading.E(e, "Wrong args: '%s'", v);
            }
            v = map.get("factory");
            if (v != null && !Strings.isBlank(v.toString())) {
                iobj.setFactory(v.toString());
            }
        }
        return iobj;
    }

    IocValue object2value(Object obj) {
        IocValue iv = new IocValue();
        if (null == obj) {
            iv.setType("null");
            return iv;
        }
        if (obj instanceof IocValue) {
            return (IocValue)obj;
        }
        if (obj instanceof Map) {
            Map.Entry en;
            Object key;
            Map map = (Map)obj;
            if (map.size() == 1 && this.supportedTypes.contains(key = (String)(en = map.entrySet().iterator().next()).getKey())) {
                iv.setType((String)key);
                iv.setValue(en.getValue());
                return iv;
            }
            if (map.size() > 0 && Iocs.isIocObject(map)) {
                iv.setType("inner");
                try {
                    iv.setValue(this.map2iobj(map));
                }
                catch (ObjectLoadException e) {
                    throw Lang.wrapThrow(e);
                }
                return iv;
            }
            HashMap newmap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                IocValue v = this.object2value(entry.getValue());
                newmap.put(entry.getKey(), v);
            }
            iv.setType("normal");
            iv.setValue(newmap);
            return iv;
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            IocValue[] ivs = new IocValue[array.length];
            for (int i = 0; i < ivs.length; ++i) {
                ivs[i] = this.object2value(array[i]);
            }
            iv.setType("normal");
            iv.setValue(ivs);
            return iv;
        }
        if (obj instanceof Collection) {
            try {
                Collection values = (Collection)Mirror.me(obj).born(new Object[0]);
                for (Object o : (Collection)obj) {
                    IocValue iocValue = this.object2value(o);
                    values.add(iocValue);
                }
                iv.setType("normal");
                iv.setValue(values);
                return iv;
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        iv.setType("normal");
        iv.setValue(obj);
        return iv;
    }
}

