/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.img;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.repo.Base64;

public class Images {
    public static BufferedImage rotate(Object srcIm, File taIm, int degree) {
        BufferedImage im = Images.read(srcIm);
        BufferedImage im2 = Images.rotate(im, degree);
        Images.write(im2, taIm);
        return im2;
    }

    public static BufferedImage rotate(String srcPath, String taPath, int degree) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.rotate(srcIm, taIm, degree);
    }

    public static BufferedImage rotate(BufferedImage image, int degree) {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degree %= 360) < 0) {
            degree = 360 + degree;
        }
        double ang = (double)degree * 0.0174532925;
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
        Graphics2D gs = rotatedImage.createGraphics();
        gs.fillRect(0, 0, w, h);
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 1);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        return image;
    }

    public static BufferedImage zoomScale(Object srcIm, File taIm, int w, int h, Color bgColor) throws IOException {
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.zoomScale(old, w, h, bgColor);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage zoomScale(String srcPath, String taPath, int w, int h, Color bgColor) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.zoomScale(srcIm, taIm, w, h, bgColor);
    }

    public static BufferedImage zoomScale(BufferedImage im, int w, int h, Color bgColor) {
        int y;
        int x;
        int nH;
        int nW;
        float nR;
        int oH;
        if (w == -1 || h == -1) {
            return Images.zoomScale(im, w, h);
        }
        int oW = im.getWidth();
        float oR = (float)oW / (float)(oH = im.getHeight());
        if (oR > (nR = (float)w / (float)h)) {
            nW = w;
            nH = (int)((float)w / oR);
            x = 0;
            y = (h - nH) / 2;
        } else if (oR < nR) {
            nH = h;
            nW = (int)((float)h * oR);
            x = (w - nW) / 2;
            y = 0;
        } else {
            nW = w;
            nH = h;
            x = 0;
            y = 0;
        }
        if (bgColor != null) {
            BufferedImage re = new BufferedImage(w, h, 2);
            Graphics2D gc = re.createGraphics();
            gc.setColor(bgColor);
            gc.fillRect(0, 0, w, h);
            gc.drawImage(im, x, y, nW, nH, bgColor, null);
            gc.dispose();
            return re;
        }
        BufferedImage nimage = new BufferedImage(nW, nH, 2);
        Graphics2D gc = nimage.createGraphics();
        nimage = gc.getDeviceConfiguration().createCompatibleImage(nW, nH, 3);
        gc.dispose();
        gc = nimage.createGraphics();
        gc.fillRect(0, 0, w, h);
        gc.setComposite(AlphaComposite.Src);
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.drawImage(im, 0, 0, nW, nH, null, null);
        gc.dispose();
        return nimage;
    }

    public static BufferedImage zoomScale(BufferedImage im, int w, int h) {
        int oW = im.getWidth();
        int oH = im.getHeight();
        int nW = w;
        int nH = h;
        if (h == -1) {
            nH = (int)((float)w / (float)oW * (float)oH);
        } else if (w == -1) {
            nW = (int)((float)h / (float)oH * (float)oW);
        }
        BufferedImage re = new BufferedImage(nW, nH, im.getType());
        re.createGraphics().drawImage(im, 0, 0, nW, nH, null);
        return re;
    }

    public static BufferedImage clipScale(Object srcIm, File taIm, int w, int h) throws IOException {
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.clipScale(old, w, h);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage clipScale(String srcPath, String taPath, int w, int h) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.clipScale((Object)srcIm, taIm, w, h);
    }

    public static BufferedImage clipScale(Object srcIm, File taIm, int[] startPoint, int[] endPoint) throws IOException {
        int width = endPoint[0] - startPoint[0];
        int height = endPoint[1] - startPoint[1];
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.clipScale(old.getSubimage(startPoint[0], startPoint[1], width, height), width, height);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage clipScale(String srcPath, String taPath, int[] startPoint, int[] endPoint) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.clipScale((Object)srcIm, taIm, startPoint, endPoint);
    }

    public static BufferedImage clipScale(BufferedImage im, int w, int h) {
        int y;
        int x;
        int nH;
        int nW;
        float nR;
        int oH;
        int oW = im.getWidth();
        float oR = (float)oW / (float)(oH = im.getHeight());
        if (oR > (nR = (float)w / (float)h)) {
            nW = h * oW / oH;
            nH = h;
            x = (w - nW) / 2;
            y = 0;
        } else if (oR < nR) {
            nW = w;
            nH = w * oH / oW;
            x = 0;
            y = (h - nH) / 2;
        } else {
            nW = w;
            nH = h;
            x = 0;
            y = 0;
        }
        BufferedImage re = new BufferedImage(w, h, 5);
        re.createGraphics().drawImage(im, x, y, nW, nH, Color.black, null);
        return re;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage read(Object img) {
        BufferedImage bufferedImage;
        if (img instanceof CharSequence) {
            return ImageIO.read(Files.checkFile(img.toString()));
        }
        if (img instanceof File) {
            return ImageIO.read((File)img);
        }
        if (img instanceof URL) {
            img = ((URL)img).openStream();
        }
        if (!(img instanceof InputStream)) throw Lang.makeThrow("Unkown img info!! --> " + img, new Object[0]);
        File tmp = File.createTempFile("nutz_img", ".jpg");
        Files.write(tmp, (Object)((InputStream)img));
        try {
            bufferedImage = Images.read(tmp);
            tmp.delete();
        }
        catch (Throwable throwable) {
            try {
                tmp.delete();
                throw throwable;
            }
            catch (IOException e) {
                try {
                    InputStream in = null;
                    if (img instanceof File) {
                        in = new FileInputStream((File)img);
                    } else if (img instanceof URL) {
                        in = ((URL)img).openStream();
                    } else if (img instanceof InputStream) {
                        in = (InputStream)img;
                    }
                    if (in == null) return null;
                    return Images.readJpeg(in);
                }
                catch (IOException e2) {
                    e2.fillInStackTrace();
                }
                return null;
            }
        }
        return bufferedImage;
    }

    public static void write(RenderedImage im, File targetFile) {
        try {
            ImageIO.write(im, Files.getSuffixName(targetFile), targetFile);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void write(RenderedImage im, String imFormat, OutputStream out) {
        try {
            ImageIO.write(im, imFormat, out);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void writeJpeg(RenderedImage im, Object targetJpg, float quality) {
        try {
            ImageWriter writer = ImageIO.getImageWritersBySuffix("jpg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            ImageOutputStream os = ImageIO.createImageOutputStream(targetJpg);
            writer.setOutput(os);
            writer.write(null, new IIOImage(im, null, null), param);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    private static BufferedImage readJpeg(InputStream in) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        ImageReader reader = null;
        while (readers.hasNext() && !(reader = readers.next()).canReadRaster()) {
        }
        ImageInputStream input = ImageIO.createImageInputStream(in);
        reader.setInput(input);
        Raster raster = reader.readRaster(0, null);
        BufferedImage image = Images.createJPEG4(raster);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Images.writeJpeg(image, out, 1.0f);
        out.flush();
        return Images.read(new ByteArrayInputStream(out.toByteArray()));
    }

    private static BufferedImage createJPEG4(Raster raster) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float k = 220.0f - K[i];
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
            rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }

    public static String encodeBase64(String targetFile) {
        return Images.encodeBase64(new File(targetFile));
    }

    public static String encodeBase64(File targetFile) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(targetFile);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        image.flush();
        try {
            ImageIO.write((RenderedImage)image, Files.getSuffixName(targetFile), bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        byte[] bImage = baos.toByteArray();
        return Base64.encodeToString(bImage, false);
    }
}

