/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.img;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Strings;

public final class Colors {
    public static Color fromString(String str) {
        Pattern p;
        Matcher m;
        if (null == str) {
            return Color.BLACK;
        }
        if ((str = Strings.trim(str.toUpperCase())).startsWith("#")) {
            str = str.substring(1);
        }
        if (str.endsWith(";")) {
            str = str.substring(0, str.length() - 1);
        }
        if ((m = (p = Pattern.compile("^([0-9A-F])([0-9A-F])([0-9A-F])$")).matcher(str)).find()) {
            return new Color(Integer.parseInt(Strings.dup(m.group(1), 2), 16), Integer.parseInt(Strings.dup(m.group(2), 2), 16), Integer.parseInt(Strings.dup(m.group(3), 2), 16));
        }
        p = Pattern.compile("^([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
        }
        p = Pattern.compile("^([0-9A-F])([0-9A-F])([0-9A-F])([0-9A-F])$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(Strings.dup(m.group(2), 2), 16), Integer.parseInt(Strings.dup(m.group(3), 2), 16), Integer.parseInt(Strings.dup(m.group(4), 2), 16), Integer.parseInt(Strings.dup(m.group(1), 2), 16));
        }
        p = Pattern.compile("^([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
        }
        p = Pattern.compile("^RGB\\s*[(]\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*[)]$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(1), 10), Integer.parseInt(m.group(2), 10), Integer.parseInt(m.group(3), 10));
        }
        p = Pattern.compile("^RGBA\\s*[(]\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*[)]$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(1), 10), Integer.parseInt(m.group(2), 10), Integer.parseInt(m.group(3), 10), Integer.parseInt(m.group(4), 10));
        }
        p = Pattern.compile("^RGBA\\s*[(]\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(0?[.][0-9]+)\\s*[)]$");
        m = p.matcher(str);
        if (m.find()) {
            float alpha = Float.parseFloat(m.group(4));
            return new Color(Integer.parseInt(m.group(1), 10), Integer.parseInt(m.group(2), 10), Integer.parseInt(m.group(3), 10), (int)(255.0f * alpha));
        }
        return Color.BLACK;
    }

    private Colors() {
    }
}

