/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http.sender;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.nutz.http.HttpException;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Streams;
import org.nutz.lang.random.R;

public class FilePostSender
extends PostSender {
    public static final String SEPARATOR = "\r\n";

    public FilePostSender(Request request) {
        super(request);
    }

    @Override
    public Response send() throws HttpException {
        try {
            String boundary = "---------------------------[Nutz]aabbcc" + R.UU32();
            this.openConnection();
            this.setupRequestHeader();
            this.conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            this.setupDoInputOutputFlag();
            Map<String, Object> params = this.request.getParams();
            if (null != params && params.size() > 0) {
                final DataOutputStream outs = new DataOutputStream(this.conn.getOutputStream());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    outs.writeBytes("--" + boundary + SEPARATOR);
                    final String key = entry.getKey();
                    Object val = entry.getValue();
                    if (val == null) {
                        val = "";
                    }
                    Lang.each(val, new Each<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                            block7: {
                                File f = null;
                                if (ele instanceof File) {
                                    f = (File)ele;
                                }
                                try {
                                    if (f != null && f.exists() && f.length() > 0L) {
                                        outs.writeBytes("Content-Disposition:    form-data;    name=\"" + key + "\";    filename=\"");
                                        outs.write(f.getName().getBytes(FilePostSender.this.request.getEnc()));
                                        outs.writeBytes("\"\r\n");
                                        outs.writeBytes("Content-Type:   application/octet-stream\r\n\r\n");
                                        InputStream is = null;
                                        try {
                                            is = Streams.fileIn(f);
                                            Streams.write((OutputStream)outs, is);
                                            outs.writeBytes(FilePostSender.SEPARATOR);
                                            break block7;
                                        }
                                        finally {
                                            Streams.safeClose(is);
                                        }
                                    }
                                    outs.writeBytes("Content-Disposition:    form-data;    name=\"" + key + "\"" + FilePostSender.SEPARATOR + FilePostSender.SEPARATOR);
                                    outs.write(String.valueOf(ele).getBytes(FilePostSender.this.request.getEnc()));
                                    outs.writeBytes(FilePostSender.SEPARATOR);
                                }
                                catch (Exception e) {
                                    throw Lang.wrapThrow(e);
                                }
                            }
                        }
                    });
                }
                outs.writeBytes("--" + boundary + "--" + SEPARATOR);
                Streams.safeFlush(outs);
                Streams.safeClose(outs);
            }
            return this.createResponse(this.getResponseHeader());
        }
        catch (IOException e) {
            throw new HttpException(this.request.getUrl().toString(), e);
        }
    }
}

