/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.http.HttpReqRespInterceptor;
import org.nutz.http.ProxySwitcher;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.sender.GetSender;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.stream.NullInputStream;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Sender {
    public static int Default_Conn_Timeout = 30000;
    public static int Default_Read_Timeout = 600000;
    private static final Log log = Logs.get();
    protected Request request;
    protected int timeout;
    protected HttpURLConnection conn;
    protected HttpReqRespInterceptor interceptor;

    public static Sender create(String url) {
        return Sender.create(Request.get(url));
    }

    public static Sender create(String url, int timeout) {
        return Sender.create(Request.get(url)).setTimeout(timeout);
    }

    public static Sender create(Request request) {
        return request.isGet() || request.isDelete() ? new GetSender(request) : new PostSender(request);
    }

    public static Sender create(Request request, int timeout) {
        Sender sender = request.isGet() || request.isDelete() ? new GetSender(request) : new PostSender(request);
        return sender.setTimeout(timeout);
    }

    protected Sender(Request request) {
        this.request = request;
    }

    public abstract Response send() throws HttpException;

    protected Response createResponse(Map<String, String> reHeaders) throws IOException {
        Response rep = null;
        if (reHeaders != null) {
            rep = new Response(this.conn, reHeaders);
            if (rep.isOK()) {
                InputStream is1 = this.conn.getInputStream();
                InputStream is2 = null;
                String encoding = this.conn.getContentEncoding();
                is2 = encoding != null && encoding.contains("gzip") ? new GZIPInputStream(is1) : (encoding != null && encoding.contains("deflate") ? new InflaterInputStream(is1, new Inflater(true)) : is1);
                BufferedInputStream is = new BufferedInputStream(is2);
                rep.setStream(is);
            } else {
                try {
                    rep.setStream(this.conn.getInputStream());
                }
                catch (IOException e) {
                    try {
                        rep.setStream(this.conn.getErrorStream());
                    }
                    catch (Exception e1) {
                        rep.setStream(new NullInputStream());
                    }
                }
            }
        }
        if (this.interceptor != null) {
            this.interceptor.afterResponse(this.request, this.conn, rep);
        }
        return rep;
    }

    protected Map<String, String> getResponseHeader() throws IOException {
        if (this.conn.getResponseCode() < 0) {
            throw new IOException("Network error!! resp code=" + this.conn.getResponseCode());
        }
        HashMap<String, String> reHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> en : this.conn.getHeaderFields().entrySet()) {
            List<String> val = en.getValue();
            if (null == val || val.size() <= 0) continue;
            reHeaders.put(en.getKey(), en.getValue().get(0));
        }
        return reHeaders;
    }

    protected void setupDoInputOutputFlag() {
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws IOException {
        block15: {
            ProxySwitcher proxySwitcher;
            if (this.interceptor != null) {
                this.interceptor.beforeConnect(this.request);
            }
            if ((proxySwitcher = Http.proxySwitcher) != null) {
                try {
                    Proxy proxy = proxySwitcher.getProxy(this.request);
                    if (proxy == null) break block15;
                    if (Http.autoSwitch) {
                        Socket socket = null;
                        try {
                            socket = new Socket();
                            socket.connect(proxy.address(), 5000);
                            OutputStream out = socket.getOutputStream();
                            out.write(10);
                            out.flush();
                        }
                        finally {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                    }
                    log.debug("connect via proxy : " + proxy + " for " + this.request.getUrl());
                    this.conn = (HttpURLConnection)this.request.getUrl().openConnection(proxy);
                    this.conn.setConnectTimeout(Default_Conn_Timeout);
                    if (this.timeout > 0) {
                        this.conn.setReadTimeout(this.timeout);
                    } else {
                        this.conn.setReadTimeout(Default_Read_Timeout);
                    }
                    return;
                }
                catch (IOException e) {
                    if (!Http.autoSwitch) {
                        throw e;
                    }
                    log.info("Test proxy FAIl, fallback to direct connection", e);
                }
            }
        }
        this.conn = (HttpURLConnection)this.request.getUrl().openConnection();
        this.conn.setConnectTimeout(Default_Conn_Timeout);
        this.conn.setRequestMethod(this.request.getMethod().name());
        if (this.timeout > 0) {
            this.conn.setReadTimeout(this.timeout);
        } else {
            this.conn.setReadTimeout(Default_Read_Timeout);
        }
        if (this.interceptor != null) {
            this.interceptor.afterConnect(this.request, this.conn);
        }
    }

    protected void setupRequestHeader() {
        URL url = this.request.getUrl();
        String host = url.getHost();
        if (url.getPort() > 0 && url.getPort() != 80) {
            host = host + ":" + url.getPort();
        }
        this.conn.setRequestProperty("Host", host);
        Header header = this.request.getHeader();
        if (null != header) {
            for (Map.Entry<String, String> entry : header.getAll()) {
                this.conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public Sender setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Sender setInterceptor(HttpReqRespInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }
}

