/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.util.cri.BetweenExpression;
import org.nutz.dao.util.cri.Exps;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.Static;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SqlExpressionGroup
extends AbstractPItem
implements SqlExpression {
    private List<SqlExpression> exps = new ArrayList<SqlExpression>();
    private boolean top = true;
    protected boolean not;
    private static final Log log = Logs.get();

    public SqlExpressionGroup and(String name, String op, Object value) {
        return this.and(Exps.create(name, op, value));
    }

    public SqlExpressionGroup and(SqlExpression exp) {
        if (exp == null) {
            if (log.isTraceEnabled()) {
                log.trace("ignore null SqlExpression");
            }
            return this;
        }
        if (!this.exps.isEmpty()) {
            this._add(new Static("AND"));
        }
        return this._add(exp);
    }

    public SqlExpressionGroup andEquals(String name, Object val) {
        if (null == val) {
            return this.andIsNull(name);
        }
        return this.and(Exps.eq(name, val));
    }

    public SqlExpressionGroup andNotEquals(String name, Object val) {
        if (null == val) {
            return this.andNotIsNull(name);
        }
        return this.and(Exps.eq(name, val).not());
    }

    public SqlExpressionGroup andIsNull(String name) {
        return this.and(Exps.isNull(name));
    }

    public SqlExpressionGroup andNotIsNull(String name) {
        return this.and(Exps.isNull(name).not());
    }

    public SqlExpressionGroup andGT(String name, long val) {
        return this.and(Exps.gt(name, val));
    }

    public SqlExpressionGroup andGTE(String name, long val) {
        return this.and(Exps.gte(name, val));
    }

    public SqlExpressionGroup andLT(String name, long val) {
        return this.and(Exps.lt(name, val));
    }

    public SqlExpressionGroup andLTE(String name, long val) {
        return this.and(Exps.lte(name, val));
    }

    public SqlExpressionGroup andIn(String name, long ... ids) {
        return this.and(Exps.inLong(name, ids));
    }

    public SqlExpressionGroup andInIntArray(String name, int ... ids) {
        return this.and(Exps.inInt(name, ids));
    }

    public SqlExpressionGroup andIn(String name, String ... names) {
        return this.and(Exps.inStr(name, names));
    }

    public SqlExpressionGroup andInBySql(String name, String subSql, Object ... args) {
        return this.and(Exps.inSql(name, subSql, args));
    }

    public SqlExpressionGroup andNotInBySql(String name, String subSql, Object ... args) {
        return this.and(Exps.inSql(name, subSql, args).not());
    }

    public SqlExpressionGroup andNotIn(String name, long ... ids) {
        return this.and(Exps.inLong(name, ids).not());
    }

    public SqlExpressionGroup andNotIn(String name, int ... ids) {
        return this.and(Exps.inInt(name, ids).not());
    }

    public SqlExpressionGroup andNotIn(String name, String ... names) {
        return this.and(Exps.inStr(name, names).not());
    }

    public SqlExpressionGroup andLike(String name, String value) {
        return this.and(Exps.like(name, value));
    }

    public SqlExpressionGroup andLikeL(String name, String value) {
        return this.and(Exps.like(name, value).left(null));
    }

    public SqlExpressionGroup andLikeR(String name, String value) {
        return this.and(Exps.like(name, value).right(null));
    }

    public SqlExpressionGroup andNotLike(String name, String value) {
        return this.and(Exps.like(name, value).not());
    }

    public SqlExpressionGroup andNotLikeL(String name, String value) {
        return this.and(Exps.like(name, value).left(null).not());
    }

    public SqlExpressionGroup andNotLikeR(String name, String value) {
        return this.and(Exps.like(name, value).right(null).not());
    }

    public SqlExpressionGroup andLike(String name, String value, boolean ignoreCase) {
        return this.and(Exps.like(name, value, ignoreCase));
    }

    public SqlExpressionGroup andNotLike(String name, String value, boolean ignoreCase) {
        return this.and(Exps.like(name, value, ignoreCase).not());
    }

    public SqlExpressionGroup andLike(String name, String value, String left, String right, boolean ignoreCase) {
        return this.and(Exps.like(name, value, ignoreCase).left(left).right(right));
    }

    public SqlExpressionGroup andNotLike(String name, String value, String left, String right, boolean ignoreCase) {
        return this.and(Exps.like(name, value, ignoreCase).left(left).right(right).not());
    }

    public SqlExpressionGroup or(String name, String op, Object value) {
        return this.or(Exps.create(name, op, value));
    }

    public SqlExpressionGroup or(SqlExpression exp) {
        if (exp == null) {
            throw new NullPointerException("exp is null!");
        }
        if (!this.exps.isEmpty()) {
            this._add(new Static("OR"));
        }
        return this._add(exp);
    }

    public SqlExpressionGroup orEquals(String name, Object val) {
        return this.or(Exps.eq(name, val));
    }

    public SqlExpressionGroup orNotEquals(String name, Object val) {
        return this.or(Exps.eq(name, val).not());
    }

    public SqlExpressionGroup orIsNull(String name) {
        return this.or(Exps.isNull(name));
    }

    public SqlExpressionGroup orNotIsNull(String name) {
        return this.or(Exps.isNull(name).not());
    }

    public SqlExpressionGroup orGT(String name, long val) {
        return this.or(Exps.gt(name, val));
    }

    public SqlExpressionGroup orGTE(String name, long val) {
        return this.or(Exps.gte(name, val));
    }

    public SqlExpressionGroup orLT(String name, long val) {
        return this.or(Exps.lt(name, val));
    }

    public SqlExpressionGroup orLTE(String name, long val) {
        return this.or(Exps.lte(name, val));
    }

    public SqlExpressionGroup orIn(String name, long ... ids) {
        return this.or(Exps.inLong(name, ids));
    }

    public SqlExpressionGroup orIn(String name, int ... ids) {
        return this.or(Exps.inInt(name, ids));
    }

    public SqlExpressionGroup orIn(String name, String ... names) {
        return this.or(Exps.inStr(name, names));
    }

    public SqlExpressionGroup orInBySql(String name, String subSql, Object ... args) {
        return this.or(Exps.inSql(name, subSql, args));
    }

    public SqlExpressionGroup orNotInBySql(String name, String subSql, Object ... args) {
        return this.or(Exps.inSql(name, subSql, args).not());
    }

    public SqlExpressionGroup orNotIn(String name, long ... ids) {
        return this.or(Exps.inLong(name, ids).not());
    }

    public SqlExpressionGroup orNotIn(String name, int ... ids) {
        return this.or(Exps.inInt(name, ids).not());
    }

    public SqlExpressionGroup orNotIn(String name, String ... names) {
        return this.or(Exps.inStr(name, names).not());
    }

    public SqlExpressionGroup orLike(String name, String value) {
        return this.or(Exps.like(name, value));
    }

    public SqlExpressionGroup orLikeL(String name, String value) {
        return this.or(Exps.like(name, value).left(null));
    }

    public SqlExpressionGroup orLikeR(String name, String value) {
        return this.or(Exps.like(name, value).right(null));
    }

    public SqlExpressionGroup orNotLike(String name, String value) {
        return this.or(Exps.like(name, value).not());
    }

    public SqlExpressionGroup orNotLikeL(String name, String value) {
        return this.or(Exps.like(name, value).left(null).not());
    }

    public SqlExpressionGroup orNotLikeR(String name, String value) {
        return this.or(Exps.like(name, value).right(null).not());
    }

    public SqlExpressionGroup orLike(String name, String value, boolean ignoreCase) {
        return this.or(Exps.like(name, value, ignoreCase));
    }

    public SqlExpressionGroup orNotLike(String name, String value, boolean ignoreCase) {
        return this.or(Exps.like(name, value, ignoreCase).not());
    }

    public SqlExpressionGroup orLike(String name, String value, String left, String right, boolean ignoreCase) {
        return this.or(Exps.like(name, value, ignoreCase).left(left).right(right));
    }

    public SqlExpressionGroup orNotLike(String name, String value, String left, String right, boolean ignoreCase) {
        return this.or(Exps.like(name, value, ignoreCase).left(left).right(right).not());
    }

    public SqlExpressionGroup andBetween(String name, Object min, Object max) {
        return this.and(new BetweenExpression(name, min, max));
    }

    public SqlExpressionGroup orBetween(String name, Object min, Object max) {
        return this.or(new BetweenExpression(name, min, max));
    }

    @Override
    public void setPojo(Pojo pojo) {
        super.setPojo(pojo);
        for (SqlExpression exp : this.exps) {
            exp.setPojo(pojo);
        }
    }

    private SqlExpressionGroup _add(SqlExpression exp) {
        if (null != exp) {
            this.exps.add(exp);
            exp.setPojo(this.pojo);
            if (exp instanceof SqlExpressionGroup) {
                ((SqlExpressionGroup)exp).top = false;
            }
        }
        return this;
    }

    @Override
    public void joinSql(Entity<?> en, StringBuilder sb) {
        if (!this.exps.isEmpty()) {
            if (this.top) {
                sb.append(" WHERE ");
                if (this.not) {
                    sb.append("NOT (");
                }
                for (SqlExpression exp : this.exps) {
                    exp.joinSql(en, sb);
                }
                if (this.not) {
                    sb.append(')');
                }
            } else {
                if (this.not) {
                    sb.append("NOT ");
                }
                sb.append('(');
                for (SqlExpression exp : this.exps) {
                    exp.joinSql(en, sb);
                }
                sb.append(')');
            }
        }
    }

    @Override
    public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
        for (SqlExpression exp : this.exps) {
            off = exp.joinAdaptor(en, adaptors, off);
        }
        return off;
    }

    @Override
    public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
        for (SqlExpression exp : this.exps) {
            off = exp.joinParams(en, obj, params, off);
        }
        return off;
    }

    @Override
    public int paramCount(Entity<?> en) {
        int re = 0;
        for (SqlExpression exp : this.exps) {
            re += exp.paramCount(en);
        }
        return re;
    }

    @Override
    public SqlExpression setNot(boolean not) {
        this.not = not;
        return this;
    }

    public boolean isEmpty() {
        return this.exps.isEmpty();
    }

    public List<SqlExpression> cloneExps() {
        return new ArrayList<SqlExpression>(this.exps);
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public List<SqlExpression> getExps() {
        return this.exps;
    }
}

