/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.nutz.castor.Castors;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.impl.jdbc.BlobValueAdaptor;
import org.nutz.dao.impl.jdbc.ClobValueAdaptor;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.ReadOnceInputStream;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.filepool.FilePool;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.meta.Email;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Trans;

public abstract class Jdbcs {
    private static final Log log = Logs.get();
    private static final JdbcExpertConfigFile conf;
    public static Map<String, ValueAdaptor> customValueAdaptorMap;

    public static JdbcExpert getExpert(DataSource ds) {
        log.info("Get Connection from DataSource for JdbcExpert, if I lock at here, check your database server and configure");
        Connection conn = null;
        try {
            conn = Trans.getConnectionAuto(ds);
            DatabaseMetaData meta = conn.getMetaData();
            String pnm = meta.getDatabaseProductName();
            String ver = meta.getDatabaseProductVersion();
            JdbcExpert jdbcExpert = Jdbcs.getExpert(pnm, ver);
            return jdbcExpert;
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Trans.closeConnectionAuto(conn);
        }
    }

    public static JdbcExpert getExpert(String productName, String version) {
        String dbName = String.format("%s::NUTZ_JDBC::%s", productName, version).toLowerCase();
        JdbcExpert re = conf.matchExpert(dbName);
        if (null == re) {
            log.warnf("unknow database type '%s %s', fallback to MySql 5", productName, version);
            re = conf.matchExpert("mysql 5");
        }
        return re;
    }

    public static ValueAdaptor getAdaptorBy(Object obj) {
        if (null == obj) {
            return Adaptor.asNull;
        }
        return Jdbcs.getAdaptor(Mirror.me(obj));
    }

    public static ValueAdaptor register(String className, ValueAdaptor adaptor) {
        if (adaptor == null) {
            return customValueAdaptorMap.remove(className);
        }
        return customValueAdaptorMap.put(className, adaptor);
    }

    public static ValueAdaptor getAdaptor(Mirror<?> mirror) {
        ValueAdaptor custom = customValueAdaptorMap.get(mirror.getType().getName());
        if (custom != null) {
            return custom;
        }
        if (mirror.isStringLike()) {
            return Adaptor.asString;
        }
        if (mirror.isInt()) {
            return Adaptor.asInteger;
        }
        if (mirror.isBoolean()) {
            return Adaptor.asBoolean;
        }
        if (mirror.isLong()) {
            return Adaptor.asLong;
        }
        if (mirror.isEnum()) {
            return Adaptor.asEnumChar;
        }
        if (mirror.isChar()) {
            return Adaptor.asChar;
        }
        if (mirror.isOf(Timestamp.class)) {
            return Adaptor.asTimestamp;
        }
        if (mirror.isByte()) {
            return Adaptor.asByte;
        }
        if (mirror.isShort()) {
            return Adaptor.asShort;
        }
        if (mirror.isFloat()) {
            return Adaptor.asFloat;
        }
        if (mirror.isDouble()) {
            return Adaptor.asDouble;
        }
        if (mirror.isOf(BigDecimal.class)) {
            return Adaptor.asBigDecimal;
        }
        if (mirror.isOf(Date.class)) {
            return Adaptor.asSqlDate;
        }
        if (mirror.isOf(Time.class)) {
            return Adaptor.asSqlTime;
        }
        if (mirror.isOf(Calendar.class)) {
            return Adaptor.asCalendar;
        }
        if (mirror.isOf(java.util.Date.class)) {
            return Adaptor.asDate;
        }
        if (mirror.isOf(Blob.class)) {
            return new BlobValueAdaptor(conf.getPool());
        }
        if (mirror.isOf(Clob.class)) {
            return new ClobValueAdaptor(conf.getPool());
        }
        if (mirror.getType().isArray() && mirror.getType().getComponentType() == Byte.TYPE) {
            return Adaptor.asBytes;
        }
        if (mirror.isOf(InputStream.class)) {
            return Adaptor.asBinaryStream;
        }
        if (mirror.isOf(Reader.class)) {
            return Adaptor.asReader;
        }
        return Adaptor.asString;
    }

    public static void guessEntityFieldColumnType(NutMappingField ef) {
        Mirror<Object> mirror = ef.getTypeMirror();
        if (mirror.isInt()) {
            ef.setColumnType(ColType.INT);
            ef.setWidth(8);
        } else if (mirror.isStringLike() || mirror.is(Email.class)) {
            ef.setColumnType(ColType.VARCHAR);
            ef.setWidth(50);
        } else if (mirror.isLong()) {
            ef.setColumnType(ColType.INT);
            ef.setWidth(16);
        } else if (mirror.isEnum()) {
            ef.setColumnType(ColType.VARCHAR);
            ef.setWidth(20);
        } else if (mirror.is(Timestamp.class)) {
            ef.setColumnType(ColType.TIMESTAMP);
        } else if (mirror.isBoolean()) {
            ef.setColumnType(ColType.BOOLEAN);
            ef.setWidth(1);
        } else if (mirror.isChar()) {
            ef.setColumnType(ColType.CHAR);
            ef.setWidth(4);
        } else if (mirror.is(Date.class)) {
            ef.setColumnType(ColType.DATE);
        } else if (mirror.is(Time.class)) {
            ef.setColumnType(ColType.TIME);
        } else if (mirror.isOf(Calendar.class) || mirror.is(java.util.Date.class)) {
            ef.setColumnType(ColType.DATETIME);
        } else if (mirror.is(BigDecimal.class)) {
            ef.setColumnType(ColType.INT);
            ef.setWidth(32);
        } else if (mirror.isShort()) {
            ef.setColumnType(ColType.INT);
            ef.setWidth(4);
        } else if (mirror.isByte()) {
            ef.setColumnType(ColType.INT);
            ef.setWidth(2);
        } else if (mirror.isFloat()) {
            ef.setColumnType(ColType.FLOAT);
        } else if (mirror.isDouble()) {
            ef.setColumnType(ColType.FLOAT);
        } else if (mirror.isOf(Reader.class) || mirror.isOf(Clob.class)) {
            ef.setColumnType(ColType.TEXT);
        } else if (mirror.isOf(InputStream.class) || mirror.is(byte[].class) || mirror.isOf(Blob.class)) {
            ef.setColumnType(ColType.BINARY);
        } else {
            if (log.isDebugEnabled()) {
                log.debugf("take field '%s(%s)'(%s) as VARCHAR(50)", ef.getName(), Lang.getTypeClass(ef.getType()).getName(), ef.getEntity().getType().getName());
            }
            ef.setColumnType(ColType.VARCHAR);
            ef.setWidth(50);
        }
    }

    public static FilePool getFilePool() {
        return conf.getPool();
    }

    public static void setFilePool(FilePool pool) {
        conf.setPool(pool);
    }

    public static void setCharacterStream(int index, Object obj, PreparedStatement stat) throws SQLException {
        try {
            File f = Jdbcs.getFilePool().createFile(".dat");
            Streams.writeAndClose((Writer)new FileWriter(f), (Reader)obj);
            stat.setCharacterStream(index, (Reader)new FileReader(f), f.length());
        }
        catch (FileNotFoundException e) {
            throw Lang.impossible();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    static {
        customValueAdaptorMap = new ConcurrentHashMap<String, ValueAdaptor>();
        try {
            File f = Files.findFile("nutz_jdbc_experts.js");
            conf = null == f ? Json.fromJson(JdbcExpertConfigFile.class, (Reader)new InputStreamReader(Jdbcs.class.getResourceAsStream("nutz_jdbc_experts.js"))).init() : Json.fromJson(JdbcExpertConfigFile.class, Streams.fileInr("nutz_jdbc_experts.js")).init();
            for (String key : conf.getExperts().keySet()) {
                conf.getExpert(key);
            }
        }
        catch (Exception e) {
            throw Lang.wrapThrow(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Jdbcs init complete");
        }
    }

    public static class Adaptor {
        public static final ValueAdaptor asNull = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return null;
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                stat.setNull(i, 0);
            }
        };
        public static final ValueAdaptor asString = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getString(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setString(i, null);
                } else {
                    stat.setString(i, Castors.me().castToString(obj));
                }
            }
        };
        public static final ValueAdaptor asChar = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                String re = Strings.trim(rs.getString(colName));
                if (re == null || re.length() == 0) {
                    return null;
                }
                return re;
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setString(i, null);
                } else {
                    char c;
                    String s = obj instanceof Character ? ((c = ((Character)obj).charValue()) >= '\u0000' && c <= ' ' ? " " : String.valueOf(c)) : obj.toString();
                    stat.setString(i, s);
                }
            }
        };
        public static final ValueAdaptor asInteger = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                int re = rs.getInt(colName);
                return rs.wasNull() ? null : Integer.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 4);
                } else {
                    int v = obj instanceof Number ? ((Number)obj).intValue() : Castors.me().castTo(obj.toString(), Integer.TYPE).intValue();
                    stat.setInt(i, v);
                }
            }
        };
        public static final ValueAdaptor asBigDecimal = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getBigDecimal(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, -5);
                } else {
                    BigDecimal v = obj instanceof BigDecimal ? (BigDecimal)obj : (obj instanceof Number ? BigDecimal.valueOf(((Number)obj).longValue()) : new BigDecimal(obj.toString()));
                    stat.setBigDecimal(i, v);
                }
            }
        };
        public static final ValueAdaptor asBoolean = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                boolean re = rs.getBoolean(colName);
                return rs.wasNull() ? null : Boolean.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 16);
                } else {
                    boolean v = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Number ? ((Number)obj).intValue() > 0 : (obj instanceof Character ? Character.toUpperCase(((Character)obj).charValue()) == 'T' : Boolean.valueOf(obj.toString())));
                    stat.setBoolean(i, v);
                }
            }
        };
        public static final ValueAdaptor asLong = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                long re = rs.getLong(colName);
                return rs.wasNull() ? null : Long.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 4);
                } else {
                    long v = obj instanceof Number ? ((Number)obj).longValue() : Castors.me().castTo(obj.toString(), Long.TYPE).longValue();
                    stat.setLong(i, v);
                }
            }
        };
        public static final ValueAdaptor asByte = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                byte re = rs.getByte(colName);
                return rs.wasNull() ? null : Byte.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, -6);
                } else {
                    byte v = obj instanceof Number ? ((Number)obj).byteValue() : Castors.me().castTo(obj.toString(), Byte.TYPE).byteValue();
                    stat.setByte(i, v);
                }
            }
        };
        public static final ValueAdaptor asShort = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                short re = rs.getShort(colName);
                return rs.wasNull() ? null : Short.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 5);
                } else {
                    short v = obj instanceof Number ? ((Number)obj).shortValue() : Castors.me().castTo(obj.toString(), Short.TYPE).shortValue();
                    stat.setShort(i, v);
                }
            }
        };
        public static final ValueAdaptor asFloat = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                float re = rs.getFloat(colName);
                return rs.wasNull() ? null : Float.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 6);
                } else {
                    float v = obj instanceof Number ? ((Number)obj).floatValue() : Castors.me().castTo(obj.toString(), Float.TYPE).floatValue();
                    stat.setFloat(i, v);
                }
            }
        };
        public static final ValueAdaptor asDouble = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                double re = rs.getDouble(colName);
                return rs.wasNull() ? null : Double.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 8);
                } else {
                    double v = obj instanceof Number ? ((Number)obj).doubleValue() : Castors.me().castTo(obj.toString(), Double.TYPE).doubleValue();
                    stat.setDouble(i, v);
                }
            }
        };
        public static final ValueAdaptor asCalendar = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                Timestamp ts = rs.getTimestamp(colName);
                if (null == ts) {
                    return null;
                }
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(ts.getTime());
                return c;
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 93);
                } else {
                    Timestamp v = obj instanceof Calendar ? new Timestamp(((Calendar)obj).getTimeInMillis()) : Castors.me().castTo(obj, Timestamp.class);
                    stat.setTimestamp(i, v);
                }
            }
        };
        public static final ValueAdaptor asTimestamp = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getTimestamp(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 93);
                } else {
                    Timestamp v = obj instanceof Timestamp ? (Timestamp)obj : Castors.me().castTo(obj, Timestamp.class);
                    stat.setTimestamp(i, v);
                }
            }
        };
        public static final ValueAdaptor asDate = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                Timestamp ts = rs.getTimestamp(colName);
                return null == ts ? null : new java.util.Date(ts.getTime());
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 93);
                } else {
                    Timestamp v = obj instanceof java.util.Date ? new Timestamp(((java.util.Date)obj).getTime()) : Castors.me().castTo(obj, Timestamp.class);
                    stat.setTimestamp(i, v);
                }
            }
        };
        public static final ValueAdaptor asSqlDate = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getDate(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 91);
                } else {
                    Date v = obj instanceof Date ? (Date)obj : Castors.me().castTo(obj, Date.class);
                    stat.setDate(i, v);
                }
            }
        };
        public static final ValueAdaptor asSqlTime = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getTime(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 92);
                } else {
                    Time v = obj instanceof Time ? (Time)obj : Castors.me().castTo(obj, Time.class);
                    stat.setTime(i, v);
                }
            }
        };
        public static final ValueAdaptor asEnumInt = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                int re = rs.getInt(colName);
                return rs.wasNull() ? null : Integer.valueOf(re);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setNull(i, 4);
                } else {
                    int v = obj instanceof Enum ? ((Enum)obj).ordinal() : Castors.me().castTo(obj, Integer.TYPE).intValue();
                    stat.setInt(i, v);
                }
            }
        };
        public static final ValueAdaptor asEnumChar = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getString(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                if (null == obj) {
                    stat.setString(i, null);
                } else {
                    String v = obj.toString();
                    stat.setString(i, v);
                }
            }
        };
        public static final ValueAdaptor asObject = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getObject(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int i) throws SQLException {
                stat.setObject(i, obj);
            }
        };
        public static final ValueAdaptor asBytes = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getBytes(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int index) throws SQLException {
                if (null == obj) {
                    stat.setNull(index, -2);
                } else {
                    stat.setBytes(index, (byte[])obj);
                }
            }
        };
        public static final ValueAdaptor asBinaryStream = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                InputStream in = rs.getBinaryStream(colName);
                if (in == null) {
                    return in;
                }
                try {
                    File f = File.createTempFile("nutzdao_blob", ".tmp");
                    Files.write(f, (Object)in);
                    in.close();
                    return new ReadOnceInputStream(f);
                }
                catch (IOException e) {
                    throw Lang.wrapThrow(e);
                }
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int index) throws SQLException {
                if (null == obj) {
                    stat.setNull(index, -2);
                } else if (obj instanceof ByteArrayInputStream) {
                    stat.setBinaryStream(index, (InputStream)obj, ((ByteArrayInputStream)obj).available());
                } else if (obj instanceof InputStream) {
                    if (obj instanceof ReadOnceInputStream && ((ReadOnceInputStream)obj).readed) {
                        throw new DaoException("");
                    }
                    try {
                        File f = Jdbcs.getFilePool().createFile(".dat");
                        Streams.writeAndClose((OutputStream)new FileOutputStream(f), (InputStream)obj);
                        stat.setBinaryStream(index, (InputStream)new FileInputStream(f), f.length());
                    }
                    catch (FileNotFoundException e) {
                        try {
                            File f = Jdbcs.getFilePool().createFile(".dat");
                            Streams.writeAndClose((OutputStream)new FileOutputStream(f), (InputStream)obj);
                            stat.setBinaryStream(index, (InputStream)new FileInputStream(f), f.length());
                        }
                        catch (FileNotFoundException e2) {
                            throw Lang.impossible();
                        }
                    }
                }
            }
        };
        public static final ValueAdaptor asReader = new ValueAdaptor(){

            @Override
            public Object get(ResultSet rs, String colName) throws SQLException {
                return rs.getCharacterStream(colName);
            }

            @Override
            public void set(PreparedStatement stat, Object obj, int index) throws SQLException {
                if (null == obj) {
                    stat.setNull(index, -2);
                } else {
                    Jdbcs.setCharacterStream(index, obj, stat);
                }
            }
        };
    }
}

