/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DaoException;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Trans;
import org.nutz.trans.Transaction;

public class NutDaoRunner
implements DaoRunner {
    private static final Log log = Logs.get();
    protected DatabaseMeta meta;

    @Override
    public void run(DataSource dataSource, ConnCallback callback) {
        Transaction t = Trans.get();
        if (null != t) {
            Connection conn = null;
            Savepoint sp = null;
            try {
                conn = t.getConnection(dataSource);
                if (this.meta.isPostgresql()) {
                    sp = conn.setSavepoint();
                }
                callback.invoke(conn);
            }
            catch (Exception e) {
                if (sp != null) {
                    try {
                        conn.rollback(sp);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (e instanceof DaoException) {
                    throw (DaoException)e;
                }
                throw new DaoException(e);
            }
        }
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            callback.invoke(conn);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DaoException) {
                throw (DaoException)e;
            }
            throw new DaoException(e);
        }
        finally {
            block24: {
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (SQLException closeE) {
                        if (!log.isWarnEnabled()) break block24;
                        log.warn("Fail to close connection!", closeE);
                    }
                }
            }
        }
    }

    public void setMeta(DatabaseMeta meta) {
        this.meta = meta;
    }
}

