/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.nutz.dao.DaoException;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutDaoExecutor
implements DaoExecutor {
    private static final Log log = Logs.get();
    protected DatabaseMeta meta;
    protected JdbcExpert expert;

    @Override
    public void exec(Connection conn, DaoStatement st) {
        try {
            st.onBefore(conn);
            switch (st.getSqlType()) {
                case SELECT: {
                    this._runSelect(conn, st);
                    break;
                }
                case ALTER: 
                case TRUNCATE: 
                case CREATE: 
                case DROP: {
                    this._runStatement(conn, st);
                    break;
                }
                case RUN: {
                    st.onAfter(conn, null, null);
                    break;
                }
                case CALL: 
                case EXEC: {
                    this._runExec(conn, st);
                    break;
                }
                default: {
                    Object[][] paramMatrix;
                    if (st.isForceExecQuery()) {
                        this._runSelect(conn, st);
                        break;
                    }
                    if (st.getSqlType() == SqlType.OTHER && log.isInfoEnabled()) {
                        log.info("Can't identify SQL type :   " + st);
                    }
                    if (null == (paramMatrix = st.getParamMatrix()) || paramMatrix.length == 0) {
                        this._runStatement(conn, st);
                        break;
                    }
                    this._runPreparedStatement(conn, st, paramMatrix);
                    break;
                }
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("SQLException", e);
                SQLException nextException = e.getNextException();
                if (nextException != null) {
                    log.debug("SQL NextException", nextException);
                }
            }
            throw new DaoException(String.format("!Nutz SQL Error: '%s'\nPreparedStatement: \n'%s'", st.toString(), st.toPreparedStatement()) + "\nCaseMessage=" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _runExec(Connection conn, DaoStatement st) throws SQLException {
        block18: {
            if (st.getContext().getPager() != null) {
                throw Lang.makeThrow(DaoException.class, "NOT Pageable : " + st, new Object[0]);
            }
            String sql = st.toPreparedStatement();
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            Object[][] paramMatrix = st.getParamMatrix();
            CallableStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareCall(sql);
                ValueAdaptor[] adaptors = st.getAdaptors();
                if (paramMatrix != null && paramMatrix.length > 0) {
                    for (int i = 0; i < paramMatrix[0].length; ++i) {
                        adaptors[i].set(stmt, paramMatrix[0][i], i + 1);
                    }
                }
                stmt.execute();
                rs = stmt.getResultSet();
                try {
                    st.onAfter(conn, rs, null);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                if (!stmt.getMoreResults()) break block18;
                rs = stmt.getResultSet();
                try {
                    if (rs != null) {
                        st.onAfter(conn, rs, null);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runSelect(Connection conn, DaoStatement st) throws SQLException {
        Pager pager;
        Object[][] paramMatrix = st.getParamMatrix();
        int startRow = -1;
        int lastRow = -1;
        if (st.getContext().getResultSetType() == 1004 && (pager = st.getContext().getPager()) != null) {
            startRow = pager.getOffset();
            lastRow = pager.getOffset() + pager.getPageSize();
        }
        String sql = st.toPreparedStatement();
        ResultSet rs = null;
        Statement stat = null;
        try {
            if (null == paramMatrix || paramMatrix.length == 0 || paramMatrix[0].length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug(st.forPrint());
                }
                stat = conn.createStatement(st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                if (st.getContext().getFetchSize() != 0) {
                    stat.setFetchSize(st.getContext().getFetchSize());
                }
                rs = stat.executeQuery(sql);
            } else {
                if (paramMatrix.length > 1 && log.isWarnEnabled()) {
                    log.warnf("Drop last %d rows parameters for:\n%s", paramMatrix.length - 1, st);
                }
                if (log.isDebugEnabled()) {
                    log.debug(st);
                }
                ValueAdaptor[] adaptors = st.getAdaptors();
                stat = conn.prepareStatement(sql, st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                if (st.getContext().getFetchSize() != 0) {
                    stat.setFetchSize(st.getContext().getFetchSize());
                }
                for (int i = 0; i < paramMatrix[0].length; ++i) {
                    adaptors[i].set((PreparedStatement)stat, paramMatrix[0][i], i + 1);
                }
                rs = ((PreparedStatement)stat).executeQuery();
            }
            if (startRow > 0) {
                rs.absolute(startRow);
            }
            st.onAfter(conn, rs, stat);
        }
        catch (Throwable throwable) {
            Daos.safeClose(stat, rs);
            throw throwable;
        }
        Daos.safeClose(stat, rs);
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _runPreparedStatement(Connection conn, DaoStatement st, Object[][] paramMatrix) throws SQLException {
        block13: {
            ValueAdaptor[] adaptors = st.getAdaptors();
            if (adaptors.length != paramMatrix[0].length) {
                throw Lang.makeThrow("DaoStatement adaptor MUST same width with param matrix.", new Object[0]);
            }
            boolean statIsClosed = false;
            String sql = st.toPreparedStatement();
            PreparedStatement pstat = null;
            if (log.isDebugEnabled()) {
                log.debug(st);
            }
            try {
                pstat = st.getContext().attr("RETURN_GENERATED_KEYS") == null ? conn.prepareStatement(sql) : conn.prepareStatement(sql, 1);
                if (paramMatrix.length == 1) {
                    for (int i = 0; i < paramMatrix[0].length; ++i) {
                        adaptors[i].set(pstat, paramMatrix[0][i], i + 1);
                    }
                    pstat.execute();
                    st.getContext().setUpdateCount(pstat.getUpdateCount());
                    st.onAfter(conn, null, pstat);
                    pstat.close();
                    statIsClosed = true;
                } else {
                    for (Object[] params : paramMatrix) {
                        for (int i = 0; i < params.length; ++i) {
                            adaptors[i].set(pstat, params[i], i + 1);
                        }
                        pstat.addBatch();
                    }
                    int[] counts = pstat.executeBatch();
                    int sum = 0;
                    for (int i : counts) {
                        if (i <= 0) continue;
                        sum += i;
                    }
                    if (sum == 0) {
                        sum = pstat.getUpdateCount();
                    }
                    st.onAfter(conn, null, pstat);
                    pstat.close();
                    statIsClosed = true;
                    st.getContext().setUpdateCount(sum);
                }
                if (statIsClosed) break block13;
            }
            catch (Throwable throwable) {
                if (!statIsClosed) {
                    Daos.safeClose(pstat);
                }
                throw throwable;
            }
            Daos.safeClose(pstat);
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runStatement(Connection conn, DaoStatement st) throws SQLException {
        boolean statIsClosed = false;
        Statement stat = null;
        String sql = st.toPreparedStatement();
        if (log.isDebugEnabled()) {
            log.debug(sql);
        }
        try {
            stat = conn.createStatement();
            stat.execute(sql);
            st.getContext().setUpdateCount(stat.getUpdateCount());
            st.onAfter(conn, null, stat);
            stat.close();
            statIsClosed = true;
        }
        finally {
            if (!statIsClosed) {
                Daos.safeClose(stat);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    public void setMeta(DatabaseMeta meta) {
        this.meta = meta;
    }

    public void setExpert(JdbcExpert expert) {
        this.expert = expert;
    }
}

