/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import org.nutz.dao.impl.sql.VarIndexImpl;
import org.nutz.dao.impl.sql.WorkingStack;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.sql.VarIndex;
import org.nutz.lang.Strings;

class SqlLiteral
implements Cloneable {
    WorkingStack stack;
    private VarIndexImpl varIndexes;
    private VarIndexImpl paramIndexes;
    private String source;
    private SqlType type;

    SqlLiteral() {
    }

    private void reset() {
        this.stack = new WorkingStack();
        this.varIndexes = new VarIndexImpl();
        this.paramIndexes = new VarIndexImpl();
    }

    VarIndex getVarIndexes() {
        return this.varIndexes;
    }

    VarIndex getParamIndexes() {
        return this.paramIndexes;
    }

    SqlLiteral valueOf(String str) {
        this.reset();
        this.source = str;
        if (null == this.source) {
            return this;
        }
        char[] cs = Strings.trim(this.source).toCharArray();
        block4: for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            switch (c) {
                case '@': {
                    if (cs[i + 1] == '@') {
                        this.stack.push(c);
                        ++i;
                        continue block4;
                    }
                    StringBuilder sb = new StringBuilder();
                    i = SqlLiteral.readTokenName(cs, i, sb);
                    if (sb.length() == 0) {
                        this.stack.push(c);
                        continue block4;
                    }
                    this.paramIndexes.add(sb.toString(), this.stack.markToken());
                    continue block4;
                }
                case '$': {
                    if (cs[i + 1] == '$') {
                        this.stack.push(c);
                        ++i;
                        continue block4;
                    }
                    StringBuilder sb = new StringBuilder();
                    i = SqlLiteral.readTokenName(cs, i, sb);
                    if (sb.length() == 0) {
                        this.stack.push(c);
                        continue block4;
                    }
                    this.varIndexes.add(sb.toString(), this.stack.markToken());
                    continue block4;
                }
                default: {
                    this.stack.push(c);
                }
            }
        }
        this.stack.finish();
        this.type = this.stack.firstEquals("SELECT") || this.stack.firstEquals("WITH") ? SqlType.SELECT : (this.stack.firstEquals("UPDATE") ? SqlType.UPDATE : (this.stack.firstEquals("INSERT") ? SqlType.INSERT : (this.stack.firstEquals("DELETE") ? SqlType.DELETE : (this.stack.firstEquals("CREATE") ? SqlType.CREATE : (this.stack.firstEquals("DROP") ? SqlType.DROP : (this.stack.firstEquals("TRUNCATE") ? SqlType.TRUNCATE : (this.stack.firstEquals("ALTER") ? SqlType.ALTER : (this.stack.firstEquals("EXEC") ? SqlType.EXEC : (this.stack.firstEquals("CALL") ? SqlType.CALL : (this.stack.firstEquals("{CALL") ? SqlType.CALL : SqlType.OTHER))))))))));
        return this;
    }

    private static int readTokenName(char[] cs, int i, StringBuilder sb) {
        ++i;
        while (i < cs.length) {
            char b = cs[i];
            if (b == '_') {
                sb.append(b);
            } else {
                if (b == '$') {
                    return i;
                }
                if (b >= '\u0000' && b <= '/' || b >= ':' && b <= '@' || b >= '[' && b <= '`' || b >= '{' && b <= '\u00a0') break;
                sb.append(b);
            }
            ++i;
        }
        return i - 1;
    }

    public SqlLiteral clone() {
        return new SqlLiteral().valueOf(this.source);
    }

    public String toString() {
        return this.source;
    }

    boolean isSELECT() {
        return SqlType.SELECT == this.type;
    }

    boolean isUPDATE() {
        return SqlType.UPDATE == this.type;
    }

    boolean isINSERT() {
        return SqlType.INSERT == this.type;
    }

    boolean isDELETE() {
        return SqlType.DELETE == this.type;
    }

    boolean isCREATE() {
        return SqlType.CREATE == this.type;
    }

    boolean isDROP() {
        return SqlType.DROP == this.type;
    }

    boolean isTRUNCATE() {
        return SqlType.TRUNCATE == this.type;
    }

    SqlType getType() {
        return this.type;
    }
}

