/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import org.nutz.castor.Castors;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.blob.SimpleBlob;
import org.nutz.dao.util.blob.SimpleClob;
import org.nutz.lang.Strings;

public abstract class NutStatement
implements DaoStatement {
    private Entity<?> entity;
    private SqlContext context = new SqlContext();
    private SqlType sqlType;
    private boolean forceExecQuery;

    @Override
    public boolean isSelect() {
        return SqlType.SELECT == this.sqlType;
    }

    @Override
    public boolean isUpdate() {
        return SqlType.UPDATE == this.sqlType;
    }

    @Override
    public boolean isDelete() {
        return SqlType.DELETE == this.sqlType;
    }

    @Override
    public boolean isInsert() {
        return SqlType.INSERT == this.sqlType;
    }

    @Override
    public boolean isCreate() {
        return SqlType.CREATE == this.sqlType;
    }

    @Override
    public boolean isDrop() {
        return SqlType.DROP == this.sqlType;
    }

    @Override
    public boolean isRun() {
        return SqlType.RUN == this.sqlType;
    }

    @Override
    public boolean isAlter() {
        return SqlType.ALTER == this.sqlType;
    }

    @Override
    public boolean isExec() {
        return SqlType.EXEC == this.sqlType;
    }

    @Override
    public boolean isCall() {
        return SqlType.CALL == this.sqlType;
    }

    @Override
    public boolean isOther() {
        return SqlType.OTHER == this.sqlType;
    }

    @Override
    public Entity<?> getEntity() {
        return this.entity;
    }

    @Override
    public DaoStatement setEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public SqlContext getContext() {
        return this.context;
    }

    public void setContext(SqlContext context) {
        this.context = context;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public DaoStatement setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    @Override
    public Object getResult() {
        return this.context.getResult();
    }

    @Override
    public <T> List<T> getList(Class<T> classOfT) {
        return (List)this.getResult();
    }

    @Override
    public <T> T getObject(Class<T> classOfT) {
        return Castors.me().castTo(this.getResult(), classOfT);
    }

    @Override
    public int getInt() {
        return this.getNumber().intValue();
    }

    @Override
    public int getInt(int defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.intValue();
    }

    @Override
    public long getLong() {
        return this.getNumber().longValue();
    }

    @Override
    public long getLong(long defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.longValue();
    }

    @Override
    public double getDouble() {
        return this.getNumber().doubleValue();
    }

    @Override
    public double getDouble(double defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getNumber().floatValue();
    }

    @Override
    public float getFloat(float defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.floatValue();
    }

    @Override
    public Number getNumber() {
        return this.getObject(Number.class);
    }

    @Override
    public String getString() {
        return this.getObject(String.class);
    }

    @Override
    public boolean getBoolean() {
        return this.getObject(Boolean.class);
    }

    @Override
    public int getUpdateCount() {
        return this.context.getUpdateCount();
    }

    @Override
    public String toString() {
        String sql = this.toPreparedStatement();
        StringBuilder sb = new StringBuilder(sql);
        Object[][] mtrx = this.getParamMatrix();
        if (null != mtrx && mtrx.length > 0 && mtrx[0].length > 0) {
            int i;
            int[] maxes = new int[mtrx[0].length];
            String[][] sss = new String[mtrx.length][mtrx[0].length];
            for (int row = 0; row < mtrx.length; ++row) {
                for (int col = 0; col < mtrx[0].length; ++col) {
                    String s = this.param2String(mtrx[row][col]);
                    maxes[col] = Math.max(maxes[col], s.length());
                    sss[row][col] = s;
                }
            }
            sb.append("\n    |");
            for (i = 0; i < mtrx[0].length; ++i) {
                sb.append(' ');
                sb.append(Strings.alignRight("" + (i + 1), maxes[i], ' '));
                sb.append(" |");
            }
            sb.append("\n    |");
            for (i = 0; i < mtrx[0].length; ++i) {
                sb.append('-');
                sb.append(Strings.dup('-', maxes[i]));
                sb.append("-|");
            }
            int maxRow = mtrx.length > 10 ? 10 : mtrx.length;
            for (int row = 0; row < maxRow; ++row) {
                sb.append("\n    |");
                for (int col = 0; col < mtrx[0].length; ++col) {
                    sb.append(' ');
                    sb.append(Strings.alignLeft(sss[row][col], maxes[col], ' '));
                    sb.append(" |");
                }
            }
            if (maxRow != mtrx.length) {
                sb.append("\n -- Only display first 10 lines , don't show the remaining record(count=" + mtrx.length + ")");
            }
            sb.append("\n  For example:> \"");
            sb.append(this.toExampleStatement(mtrx, sql));
            sb.append('\"');
        }
        return sb.toString();
    }

    protected String toExampleStatement(Object[][] mtrx, String sql) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] ss = sql.split("[?]");
        if (mtrx.length > 0) {
            for (i = 0; i < mtrx[0].length; ++i) {
                sb.append(ss[i]);
                Object obj = mtrx[0][i];
                if (obj != null) {
                    if (obj instanceof Blob) {
                        Blob blob = (Blob)obj;
                        obj = "Blob(" + blob.hashCode() + ")";
                    } else if (obj instanceof Clob) {
                        Clob clob = (Clob)obj;
                        obj = "Clob(" + clob.hashCode() + ")";
                    } else if (obj instanceof byte[] || obj instanceof char[]) {
                        if (Array.getLength(obj) > 10240) {
                            obj = "*BigData[len=" + Array.getLength(obj) + "]";
                        }
                    } else if (obj instanceof InputStream) {
                        try {
                            obj = "*InputStream[len=" + ((InputStream)obj).available() + "]";
                        }
                        catch (IOException iOException) {}
                    } else if (obj instanceof Reader) {
                        obj = "*Reader@" + obj.hashCode();
                    }
                }
                sb.append(Sqls.formatFieldValue(obj));
            }
        }
        if (i < ss.length) {
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    protected String toStatement(Object[][] mtrx, String sql) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] ss = sql.split("[?]");
        if (mtrx.length > 0) {
            for (i = 0; i < mtrx[0].length; ++i) {
                sb.append(ss[i]);
                sb.append(Sqls.formatFieldValue(mtrx[0][i]));
            }
        }
        while (i < ss.length) {
            sb.append(ss[i]);
            ++i;
        }
        return sb.toString();
    }

    protected String param2String(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            if (blob instanceof SimpleBlob) {
                try {
                    return "Blob(len=" + blob.length() + ")";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "Blob(hascode=" + blob.hashCode() + ")";
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            if (clob instanceof SimpleClob) {
                try {
                    return "Clob(len=" + clob.length() + ")";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "Clob(" + clob.hashCode() + ")";
        }
        if (obj instanceof byte[] || obj instanceof char[]) {
            if (Array.getLength(obj) > 10240) {
                return "*BigData[len=" + Array.getLength(obj) + "]";
            }
        } else if (obj instanceof InputStream) {
            try {
                obj = "*InputStream[len=" + ((InputStream)obj).available() + "]";
            }
            catch (IOException iOException) {}
        } else if (obj instanceof Reader) {
            obj = "*Reader@" + obj.hashCode();
        }
        return Castors.me().castToString(obj);
    }

    @Override
    public void forceExecQuery() {
        this.forceExecQuery = true;
    }

    @Override
    public boolean isForceExecQuery() {
        return this.forceExecQuery;
    }

    @Override
    public String forPrint() {
        return super.toString();
    }
}

