/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.PojoCallback;
import org.nutz.dao.sql.PojoMaker;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Pojos;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;

public class NutPojoMaker
implements PojoMaker {
    private JdbcExpert expert;

    public NutPojoMaker(JdbcExpert expert) {
        this.expert = expert;
    }

    @Override
    public Pojo makePojo(SqlType type) {
        return this.expert.createPojo(type);
    }

    @Override
    public Pojo makeInsert(Entity<?> en) {
        MappingField mf;
        Pojo pojo = Pojos.pojo(this.expert, en, SqlType.INSERT);
        pojo.setEntity(en);
        pojo.append(Pojos.Items.entityTableName());
        pojo.append(Pojos.Items.insertFields());
        pojo.append(Pojos.Items.insertValues());
        if (this.expert.isSupportAutoIncrement() && (mf = en.getIdField()) != null && mf.isAutoIncreasement()) {
            pojo.setAfter(new GeneratedKeys());
            pojo.getContext().attr("RETURN_GENERATED_KEYS", true);
        }
        return pojo;
    }

    @Override
    public Pojo makeUpdate(Entity<?> en, Object refer) {
        Pojo pojo = Pojos.pojo(this.expert, en, SqlType.UPDATE);
        pojo.setEntity(en);
        pojo.append(Pojos.Items.entityTableName());
        pojo.append(Pojos.Items.updateFields(refer));
        return pojo;
    }

    @Override
    public Pojo makeQuery(Entity<?> en) {
        Pojo pojo = Pojos.pojo(this.expert, en, SqlType.SELECT);
        pojo.setEntity(en);
        pojo.append(Pojos.Items.queryEntityFields());
        pojo.append(Pojos.Items.wrap("FROM"));
        pojo.append(Pojos.Items.entityViewName());
        return pojo;
    }

    @Override
    public Pojo makeQuery(String tableName) {
        String[] ss = tableName.split(":");
        Pojo pojo = this.makePojo(SqlType.SELECT);
        pojo.append(Pojos.Items.wrap("*"));
        pojo.append(Pojos.Items.wrap("FROM"));
        pojo.append(Pojos.Items.wrap(ss[0]));
        return pojo;
    }

    @Override
    public Pojo makeDelete(Entity<?> en) {
        Pojo pojo = Pojos.pojo(this.expert, en, SqlType.DELETE);
        pojo.setEntity(en);
        pojo.append(Pojos.Items.wrap("FROM"));
        pojo.append(Pojos.Items.entityTableName());
        return pojo;
    }

    @Override
    public Pojo makeDelete(String tableName) {
        Pojo pojo = this.makePojo(SqlType.DELETE);
        pojo.append(Pojos.Items.wrap("FROM"));
        pojo.append(Pojos.Items.wrap(tableName));
        return pojo;
    }

    @Override
    public Pojo makeFunc(String tableName, String funcName, String colName) {
        Pojo pojo = this.makePojo(SqlType.SELECT);
        pojo.append(Pojos.Items.wrapf("%s(%s) FROM %s", funcName, colName, tableName));
        return pojo;
    }

    static class GeneratedKeys
    implements PojoCallback {
        GeneratedKeys() {
        }

        @Override
        public Object invoke(Connection conn, ResultSet rs, final Pojo pojo, Statement stmt) throws SQLException {
            final ResultSet _rs = stmt.getGeneratedKeys();
            Lang.each(pojo.getOperatingObject(), new Each<Object>(){

                @Override
                public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                    try {
                        if (!_rs.next()) {
                            throw new ExitLoop();
                        }
                        Object key = _rs.getObject(1);
                        pojo.getEntity().getIdField().setValue(ele, key);
                    }
                    catch (SQLException e) {
                        throw new DaoException(e);
                    }
                }
            });
            return pojo.getOperatingObject();
        }
    }
}

