/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.derby;

import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.impl.jdbc.derby.DerbyBooleanAdaptor;
import org.nutz.dao.impl.jdbc.mysql.MysqlJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;

public class DerbyJdbcExpert
extends MysqlJdbcExpert {
    public DerbyJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.DERBY.name();
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        if (ef.getTypeMirror().isBoolean()) {
            return new DerbyBooleanAdaptor();
        }
        return super.getAdaptor(ef);
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" OFFSET %d ROWS FETCH NEXT %d ROW ONLY", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            sql.setSourceSql(sql.getSourceSql() + String.format(" OFFSET %d ROWS FETCH NEXT %d ROW ONLY", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case INT: {
                int width = mf.getWidth();
                if (width < 8) {
                    return "INT";
                }
                return "BIGINT";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case BOOLEAN: {
                return "varchar(1)";
            }
            case BINARY: {
                return "BLOB";
            }
            case TEXT: {
                return "CLOB";
            }
        }
        return super.evalFieldType(mf);
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnName());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isUnsigned()) {
                    sb.append(" UNSIGNED");
                }
                if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" generated by default as identity");
                }
                if (mf.getColumnType() == ColType.TIMESTAMP) {
                    if (mf.hasDefaultValue()) {
                        sb.append(" ").append(this.getDefaultValue(mf));
                    } else if (mf.isNotNull()) {
                        sb.append(" DEFAULT 0");
                    } else {
                        sb.append(" DEFAULT NULL");
                    }
                } else if (mf.hasDefaultValue()) {
                    this.addDefaultValue(sb, mf);
                }
            }
            if (mf.hasColumnComment()) {
                sb.append(" COMMENT '").append(mf.getColumnComment()).append("'");
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnName()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (en.hasTableComment()) {
            sb.append(" COMMENT='").append(en.getTableComment()).append("'");
        }
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        return true;
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " LIMIT 1";
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        String autoSql = "select IDENTITY_VAL_LOCAL() as id from " + en.getTableName();
        SqlFieldMacro autoInfo = new SqlFieldMacro(idField, autoSql);
        autoInfo.setEntity(en);
        return autoInfo;
    }
}

