/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.db2;

import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.impl.jdbc.db2.DB2BooleanAdaptor;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;

public class Db2JdbcExpert
extends AbstractJdbcExpert {
    public Db2JdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.DB2.name();
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            if (mf.isReadonly()) continue;
            sb.append('\n').append(mf.getColumnName());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isNotNull() || mf.isPk()) {
                    sb.append(" NOT NULL");
                }
                if (mf.hasDefaultValue()) {
                    this.addDefaultValue(sb, mf);
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" generated by default as identity ");
                }
                if (mf.isPk() && en.getPks().size() == 1) {
                    sb.append(" primary key ");
                }
            }
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        if (en.getPks().size() > 1) {
            sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(en.getTableName()).append(" ADD CONSTRAINT PK_");
            sb.append(this.makePksName(en));
            sb.append(" PRIMARY KEY (");
            for (MappingField mf : en.getPks()) {
                sb.append(mf.getColumnName()).append(",");
            }
            sb.setCharAt(sb.length() - 1, ')');
            dao.execute(Sqls.create(sb.toString()));
        }
        this.createRelation(dao, en);
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.addComment(dao, en);
        return true;
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case BOOLEAN: {
                return "SMALLINT";
            }
            case INT: {
                return "INTEGER";
            }
            case FLOAT: {
                if (mf.getWidth() > 0 && mf.getPrecision() > 0) {
                    return "decimal(" + mf.getWidth() + "," + mf.getPrecision() + ")";
                }
                if (mf.getTypeMirror().isDouble()) {
                    return "decimal(15,10)";
                }
                return "FLOAT";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
        }
        return super.evalFieldType(mf);
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            pojo.insertFirst(Pojos.Items.wrap("SELECT * FROM (SELECT ROW_NUMBER() OVER() AS ROWNUM, T.* FROM ("));
            pojo.append(Pojos.Items.wrapf(") T) AS A WHERE ROWNUM BETWEEN %d AND %d", pager.getOffset() + 1, pager.getOffset() + pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (null != pager && pager.getPageNumber() > 0) {
            String pre = "SELECT * FROM (SELECT ROW_NUMBER() OVER() AS ROWNUM, T.* FROM (";
            String last = String.format(") T) AS A WHERE ROWNUM BETWEEN %d AND %d", pager.getOffset() + 1, pager.getOffset() + pager.getPageSize());
            sql.setSourceSql(pre + sql.getSourceSql() + last);
        }
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        if (ef.getTypeMirror().isBoolean()) {
            return new DB2BooleanAdaptor();
        }
        return super.getAdaptor(ef);
    }
}

