/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.Sqls;
import org.nutz.dao.TableName;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityField;
import org.nutz.dao.entity.EntityIndex;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.PK;
import org.nutz.dao.impl.entity.field.ManyManyLinkField;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class AbstractJdbcExpert
implements JdbcExpert {
    private static final Log log = Logs.get();
    private static String DEFAULT_COMMENT_TABLE = "comment on table $table is '$tableComment'";
    private static String DEFAULT_COMMENT_COLUMN = "comment on column $table.$column is '$columnComment'";
    protected JdbcExpertConfigFile conf;

    public AbstractJdbcExpert(JdbcExpertConfigFile conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupEntityField(Connection conn, Entity<?> en) {
        Statement stat = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            stat = conn.createStatement();
            rs = stat.executeQuery(this.createResultSetMetaSql(en));
            rsmd = rs.getMetaData();
            for (MappingField mf : en.getMappingFields()) {
                try {
                    int ci = Daos.getColumnIndex(rsmd, mf.getColumnName());
                    if (0 == rsmd.isNullable(ci)) {
                        mf.setAsNotNull();
                    }
                    if (!mf.getTypeMirror().isEnum()) continue;
                    if (Daos.isIntLikeColumn(rsmd, ci)) {
                        mf.setColumnType(ColType.INT);
                        continue;
                    }
                    mf.setColumnType(ColType.VARCHAR);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            block9: {
                try {
                    if (!log.isDebugEnabled()) break block9;
                    log.debugf("Table '%s' doesn't exist!", en.getViewName());
                }
                catch (Throwable throwable) {
                    Daos.safeClose(stat, rs);
                    throw throwable;
                }
            }
            Daos.safeClose(stat, rs);
        }
        Daos.safeClose(stat, rs);
    }

    @Override
    public ValueAdaptor getAdaptor(MappingField ef) {
        Mirror<?> mirror = ef.getTypeMirror();
        if (mirror.isEnum() && ColType.INT == ef.getColumnType()) {
            return Jdbcs.Adaptor.asEnumInt;
        }
        return Jdbcs.getAdaptor(mirror);
    }

    @Override
    public Pojo createPojo(SqlType type) {
        return new NutPojo().setSqlType(type);
    }

    @Override
    public boolean dropEntity(Dao dao, Entity<?> en) {
        String tableName = en.getTableName();
        String viewName = en.getViewName();
        try {
            this.dropRelation(dao, en);
            if (!tableName.equals(viewName) && dao.exists(viewName)) {
                dao.execute(Sqls.create("DROP VIEW " + viewName));
            }
            dao.execute(Sqls.create("DROP TABLE " + tableName));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getConf() {
        return this.conf.getConfig();
    }

    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " where 1!=1";
    }

    public void createRelation(Dao dao, Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>(5);
        for (LinkField lf : en.visitManyMany(null, null, null)) {
            ManyManyLinkField mm = (ManyManyLinkField)lf;
            if (dao.exists(mm.getRelationName())) continue;
            String sql = "CREATE TABLE " + mm.getRelationName() + "(";
            sql = sql + mm.getFromColumnName() + " " + this.evalFieldType(mm.getHostField()) + ",";
            sql = sql + mm.getToColumnName() + " " + this.evalFieldType(mm.getLinkedField());
            sql = sql + ")";
            sqls.add(Sqls.create(sql));
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    protected void dropRelation(Dao dao, Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>(5);
        for (LinkField lf : en.visitManyMany(null, null, null)) {
            ManyManyLinkField mm = (ManyManyLinkField)lf;
            if (!dao.exists(mm.getRelationName())) continue;
            sqls.add(Sqls.create("DROP TABLE " + mm.getRelationName()));
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    @Override
    public String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        switch (mf.getColumnType()) {
            case CHAR: {
                return "CHAR(" + mf.getWidth() + ")";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case VARCHAR: {
                return "VARCHAR(" + mf.getWidth() + ")";
            }
            case TEXT: {
                return "TEXT";
            }
            case BINARY: {
                return "BLOB";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case DATETIME: {
                return "DATETIME";
            }
            case DATE: {
                return "DATE";
            }
            case TIME: {
                return "TIME";
            }
            case INT: {
                if (mf.getWidth() > 0) {
                    return "INT(" + mf.getWidth() + ")";
                }
                return "INT";
            }
            case FLOAT: {
                if (mf.getWidth() > 0 && mf.getPrecision() > 0) {
                    return "NUMERIC(" + mf.getWidth() + "," + mf.getPrecision() + ")";
                }
                if (mf.getTypeMirror().isDouble()) {
                    return "NUMERIC(15,10)";
                }
                return "FLOAT";
            }
            case PSQL_ARRAY: {
                return "ARRAY";
            }
            case PSQL_JSON: {
                return "JSON";
            }
        }
        throw Lang.makeThrow("Unsupport colType '%s' of field '%s' in '%s' ", new Object[]{mf.getColumnType(), mf.getName(), mf.getEntity().getType().getName()});
    }

    protected static List<DaoStatement> wrap(String ... sqls) {
        ArrayList<DaoStatement> sts = new ArrayList<DaoStatement>(sqls.length);
        for (String sql : sqls) {
            if (Strings.isBlank(sql)) continue;
            sts.add(Sqls.create(sql));
        }
        return sts;
    }

    protected static List<DaoStatement> wrap(List<String> sqls) {
        ArrayList<DaoStatement> sts = new ArrayList<DaoStatement>(sqls.size());
        for (String sql : sqls) {
            if (Strings.isBlank(sql)) continue;
            sts.add(Sqls.create(sql));
        }
        return sts;
    }

    protected static String gSQL(String ptn, String table, String field) {
        CharSegment cs = new CharSegment(ptn);
        cs.set("T", table).set("F", field);
        return cs.toString();
    }

    protected String getDefaultValue(MappingField mf) {
        return mf.getDefaultValue(null).replaceAll("@", "@@");
    }

    protected List<Sql> createIndexs(Entity<?> en) {
        ArrayList<Sql> sqls = new ArrayList<Sql>();
        StringBuilder sb = new StringBuilder();
        List<EntityIndex> indexs = en.getIndexes();
        for (EntityIndex index : indexs) {
            sb.setLength(0);
            if (index.isUnique()) {
                sb.append("Create UNIQUE Index ");
            } else {
                sb.append("Create Index ");
            }
            if (index.getName().contains("$")) {
                sb.append(TableName.render(new CharSegment(index.getName())));
            } else {
                sb.append(index.getName());
            }
            sb.append(" ON ").append(en.getTableName()).append("(");
            for (EntityField field : index.getFields()) {
                if (field instanceof MappingField) {
                    MappingField mf = (MappingField)field;
                    sb.append(mf.getColumnName()).append(',');
                    continue;
                }
                throw Lang.makeThrow(DaoException.class, "%s %s is NOT a mapping field, can't use as index field!!", en.getClass(), field.getName());
            }
            sb.setCharAt(sb.length() - 1, ')');
            sqls.add(Sqls.create(sb.toString()));
        }
        return sqls;
    }

    public void addComment(Dao dao, Entity<?> en) {
        this.addComment(dao, en, null, null);
    }

    public void addComment(Dao dao, Entity<?> en, String commentTable, String commentColumn) {
        if (!en.hasTableComment() && !en.hasColumnComment()) {
            return;
        }
        ArrayList<Sql> sqls = new ArrayList<Sql>();
        if (en.hasTableComment()) {
            Sql tableCommentSQL = Sqls.create(Strings.isBlank(commentTable) ? DEFAULT_COMMENT_TABLE : commentTable);
            tableCommentSQL.vars().set("table", en.getTableName()).set("tableComment", en.getTableComment());
            sqls.add(tableCommentSQL);
        }
        if (en.hasColumnComment()) {
            for (MappingField mf : en.getMappingFields()) {
                if (!mf.hasColumnComment()) continue;
                Sql columnCommentSQL = Sqls.create(Strings.isBlank(commentColumn) ? DEFAULT_COMMENT_COLUMN : commentColumn);
                columnCommentSQL.vars().set("table", en.getTableName()).set("column", mf.getColumnName()).set("columnComment", mf.getColumnComment());
                sqls.add(columnCommentSQL);
            }
        }
        dao.execute(sqls.toArray(new Sql[sqls.size()]));
    }

    @Override
    public void formatQuery(DaoStatement daoStatement) {
        if (daoStatement == null) {
            return;
        }
        SqlContext ctx = daoStatement.getContext();
        if (ctx == null || ctx.getPager() == null) {
            return;
        }
        if (daoStatement instanceof Pojo) {
            this.formatQuery((Pojo)daoStatement);
        } else if (daoStatement instanceof Sql) {
            this.formatQuery((Sql)daoStatement);
        } else {
            throw Lang.noImplement();
        }
    }

    public abstract void formatQuery(Pojo var1);

    public void formatQuery(Sql sql) {
        throw Lang.noImplement();
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        String autoSql = "SELECT MAX($field) AS $field FROM $view";
        SqlFieldMacro autoInfo = new SqlFieldMacro(idField, autoSql);
        autoInfo.setEntity(en);
        return autoInfo;
    }

    @Override
    public boolean isSupportAutoIncrement() {
        return true;
    }

    public String makePksName(Entity<?> en) {
        String name = en.getType().getAnnotation(PK.class).name();
        if (Strings.isBlank(name)) {
            StringBuilder sb = new StringBuilder();
            for (MappingField mf : en.getPks()) {
                sb.append("_").append(mf.getColumnName());
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return name;
    }

    public void addDefaultValue(StringBuilder sb, MappingField mf) {
        if (!mf.hasDefaultValue()) {
            return;
        }
        if (mf.getTypeMirror().isNumber()) {
            sb.append(" DEFAULT ").append(this.getDefaultValue(mf));
        } else {
            sb.append(" DEFAULT '").append(this.getDefaultValue(mf)).append('\'');
        }
    }

    @Override
    public boolean addColumnNeedColumn() {
        return true;
    }

    @Override
    public boolean supportTimestampDefault() {
        return true;
    }
}

