/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.dao.DaoException;
import org.nutz.dao.SqlManager;
import org.nutz.dao.SqlNotFoundException;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class FileSqlManager
implements SqlManager {
    private static final Log log = Logs.get();
    Map<String, String> sqls = Collections.synchronizedMap(new LinkedHashMap());
    protected String[] paths;
    protected boolean allowDuplicate = true;

    public FileSqlManager(String ... paths) {
        this.paths = paths;
        this.refresh();
    }

    @Override
    public void refresh() {
        for (String path : this.paths) {
            List<NutResource> list = Scans.me().scan(path, ".(sql|sqlx|sqls)$");
            for (NutResource res : list) {
                int c = this.count();
                log.debugf("load >> %s from root=%s", res.getName(), path);
                try {
                    this.add(res.getReader());
                }
                catch (IOException e) {
                    log.warnf("fail to load %s from root=%s", res.getName(), path, e);
                }
                log.debugf("load %d sql >> %s from root=%s", this.count() - c, res.getName(), path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Reader r) throws IOException {
        try {
            String line;
            BufferedReader br = null;
            br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
            StringBuilder key = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            block3: while (br.ready() && (line = Streams.nextLineTrim(br)) != null) {
                if (line.startsWith("/*")) {
                    if (key.length() > 0 && line.contains("*/") && !line.endsWith("*/")) {
                        sb.append(line);
                        continue;
                    }
                    if (key.length() > 0 && sb.length() > 0) {
                        this.addSql(key.toString(), sb.toString());
                    }
                    key.setLength(0);
                    sb.setLength(0);
                    if (line.endsWith("*/")) {
                        if (line.length() <= 4) continue;
                        key.append(line.substring(2, line.length() - 2).trim());
                        continue;
                    }
                    key.append(line.substring(2).trim());
                    while (br.ready()) {
                        line = Streams.nextLineTrim(br);
                        if (line == null) break block3;
                        if (line.endsWith("*/")) {
                            if (line.length() <= 2) continue block3;
                            key.append(line.substring(0, line.length() - 2).trim());
                            continue block3;
                        }
                        key.append(line);
                    }
                }
                if (key.length() == 0) {
                    log.infof("skip not key sql line %s", line);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            if (key.length() > 0 && sb.length() > 0) {
                this.addSql(key.toString(), sb.toString());
            }
        }
        finally {
            Streams.safeClose(r);
        }
    }

    @Override
    public String get(String key) throws SqlNotFoundException {
        String sql = this.sqls.get(key);
        if (sql == null) {
            throw new SqlNotFoundException(key);
        }
        return sql;
    }

    @Override
    public Sql create(String key) throws SqlNotFoundException {
        return Sqls.create(this.get(key));
    }

    @Override
    public List<Sql> createCombo(String ... keys) {
        if (keys.length == 0) {
            keys = this.keys();
        }
        ArrayList<Sql> list = new ArrayList<Sql>(keys.length);
        for (String key : keys) {
            list.add(this.create(key));
        }
        return list;
    }

    @Override
    public int count() {
        return this.sqls.size();
    }

    @Override
    public String[] keys() {
        Set<String> keys = this.sqls.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public synchronized void addSql(String key, String value) {
        log.debugf("key=[%s], sql=[%s]", key, value);
        if (!this.isAllowDuplicate() && this.sqls.containsKey(key)) {
            throw new DaoException("Duplicate sql key=[" + key + "]");
        }
        this.sqls.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.sqls.remove(key);
    }

    public void setAllowDuplicate(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
    }

    public boolean isAllowDuplicate() {
        return this.allowDuplicate;
    }

    @Deprecated
    public String getRegex() {
        return null;
    }

    @Deprecated
    public FileSqlManager setRegex(String regex) {
        log.warn("SqlManager regex is Deprecated!! it will be ignore!!");
        return this;
    }
}

