/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.Dao;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.DaoSupport;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.eject.EjectFromMap;
import org.nutz.lang.inject.InjectToMap;

public class EntityHolder {
    public EntityMaker maker;
    private DaoSupport support;
    private Map<Class<?>, Entity<?>> map;

    public EntityHolder(DaoSupport support) {
        this.support = support;
        this.map = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Entity<?> en) {
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            this.map.put(en.getType(), en);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entity<?> en) {
        if (en == null || en.getType() == null) {
            return;
        }
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            this.map.remove(en.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Entity<T> getEntity(Class<T> classOfT) {
        Entity<Object> re = this.map.get(classOfT);
        if (null == re || !re.isComplete()) {
            Map<Class<?>, Entity<?>> map = this.map;
            synchronized (map) {
                re = this.map.get(classOfT);
                if (null == re) {
                    re = this.maker.make(classOfT);
                    this.map.put(classOfT, re);
                }
            }
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Entity<T> reloadEntity(Dao dao, Class<T> classOfT) {
        final Entity<T> re = this.maker.make(classOfT);
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            this.map.put(classOfT, re);
        }
        this.support.expert.createEntity(dao, re);
        this.support.run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                ((EntityHolder)EntityHolder.this).support.expert.setupEntityField(conn, re);
            }
        });
        return re;
    }

    public <T extends Map<String, ?>> Entity<T> makeEntity(String tableName, T map) {
        final NutEntity en = new NutEntity(map.getClass());
        en.setTableName(tableName);
        en.setViewName(tableName);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("#")) {
                en.getMetas().put(key.substring(1), entry.getValue().toString());
                continue;
            }
            if (key.startsWith(".")) continue;
            Object value = entry.getValue();
            Mirror<?> mirror = Mirror.me(value);
            NutMappingField ef = new NutMappingField(en);
            if (key.startsWith("+")) {
                ef.setAsAutoIncreasement();
                key = key.substring(1);
            }
            if (key.startsWith("!")) {
                ef.setAsNotNull();
                key = key.substring(1);
            }
            if (key.startsWith("*")) {
                key = key.substring(1);
                if (mirror != null && mirror.isIntLike()) {
                    ef.setAsId();
                } else {
                    ef.setAsName();
                }
            }
            ef.setName(key);
            ef.setType((Type)((Object)(null == value ? Object.class : value.getClass())));
            ef.setColumnName(key);
            Jdbcs.guessEntityFieldColumnType(ef);
            ef.setAdaptor(this.support.expert.getAdaptor(ef));
            if (mirror != null) {
                ef.setType(mirror.getType());
            }
            ef.setInjecting(new InjectToMap(key));
            ef.setEjecting(new EjectFromMap(key));
            en.addMappingField(ef);
        }
        en.checkCompositeFields(null);
        this.support.run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                ((EntityHolder)EntityHolder.this).support.expert.setupEntityField(conn, en);
            }
        });
        return en;
    }

    public Entity<?> getEntityBy(Object obj) {
        Object first = Lang.first(obj);
        if (first == null) {
            return null;
        }
        if (first instanceof Map) {
            Object tableName = ((Map)first).get(".table");
            if (null == tableName) {
                throw Lang.makeThrow("Can not insert map without key '.table' : \n%s", Json.toJson(first, JsonFormat.forLook()));
            }
            return this.makeEntity(tableName.toString(), (Map)first);
        }
        return this.getEntity(first.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasType(Class<?> typeName) {
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            return this.map.containsKey(typeName);
        }
    }
}

