/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.SqlManager;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.AnnotationEntityMaker;
import org.nutz.dao.impl.sql.NutPojoMaker;
import org.nutz.dao.impl.sql.run.NutDaoExecutor;
import org.nutz.dao.impl.sql.run.NutDaoRunner;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.PojoMaker;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlContext;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.nutz.trans.Transaction;

public class DaoSupport {
    private static final Log log = Logs.get();
    protected DaoRunner runner = new NutDaoRunner();
    protected DaoExecutor executor = new NutDaoExecutor();
    protected DataSource dataSource;
    protected JdbcExpert expert;
    protected PojoMaker pojoMaker;
    protected EntityHolder holder;
    private DatabaseMeta meta;
    private SqlManager sqlManager;
    protected int autoTransLevel = 2;

    public SqlManager sqls() {
        return this.sqlManager;
    }

    public DatabaseMeta meta() {
        return this.meta;
    }

    public void setSqlManager(SqlManager sqls) {
        this.sqlManager = sqls;
        if (sqls != null) {
            int count = sqls.count();
            log.debug("SqlManager Sql count=" + count);
        }
    }

    public void setRunner(DaoRunner runner) {
        this.runner = runner;
        if (runner instanceof NutDaoRunner) {
            ((NutDaoRunner)runner).setMeta(this.meta);
        }
    }

    public void setExecutor(DaoExecutor executor) {
        this.executor = executor;
        if (executor instanceof NutDaoExecutor) {
            ((NutDaoExecutor)executor).setMeta(this.meta);
            ((NutDaoExecutor)executor).setExpert(this.expert);
        }
    }

    public void setPojoMaker(PojoMaker pojoMaker) {
        this.pojoMaker = pojoMaker;
    }

    public JdbcExpert getJdbcExpert() {
        return this.expert;
    }

    public void setDataSource(DataSource ds) {
        if (null != this.dataSource && log.isWarnEnabled()) {
            log.warn("Replaced a running dataSource!");
        }
        this.dataSource = ds;
        if (this.expert == null) {
            this.expert = Jdbcs.getExpert(ds);
        }
        this.pojoMaker = new NutPojoMaker(this.expert);
        this.meta = new DatabaseMeta();
        this.run(new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                DatabaseMetaData dmd = conn.getMetaData();
                DaoSupport.this.meta.setProductName(dmd.getDatabaseProductName());
                DaoSupport.this.meta.setVersion(dmd.getDatabaseProductVersion());
                log.debug("JDBC Driver --> " + dmd.getDriverVersion());
                log.debug("JDBC Name   --> " + dmd.getDriverName());
                if (!Strings.isBlank(dmd.getURL())) {
                    log.debug("JDBC URL    --> " + dmd.getURL());
                }
                if (dmd.getDriverName().contains("mariadb") || dmd.getDriverName().contains("sqlite")) {
                    log.warn("Auto-select fetch size to Integer.MIN_VALUE, enable for ResultSet Streaming");
                    SqlContext.DEFAULT_FETCH_SIZE = Integer.MIN_VALUE;
                }
                if (log.isDebugEnabled() && DaoSupport.this.meta.isMySql()) {
                    String sql = "SHOW VARIABLES LIKE 'character_set%'";
                    Statement stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        log.debugf("Mysql : %s=%s", rs.getString(1), rs.getString(2));
                    }
                    rs.close();
                    String dbName = "";
                    rs = stmt.executeQuery("SELECT DATABASE()");
                    if (rs.next()) {
                        dbName = rs.getString(1);
                        log.debug("Mysql : database=" + dbName);
                    }
                    rs.close();
                    rs = stmt.executeQuery("SELECT USER()");
                    if (rs.next()) {
                        log.debug("Mysql : user=" + rs.getString(1));
                    }
                    rs.close();
                    stmt.close();
                    PreparedStatement pstmt = conn.prepareStatement("SELECT TABLE_NAME FROM information_schema.TABLES where TABLE_SCHEMA = ? and engine = 'MyISAM'");
                    pstmt.setString(1, dbName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        log.debug("Mysql : '" + rs.getString(1) + "' engine=MyISAM");
                    }
                    rs.close();
                    pstmt.close();
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Database info --> " + this.meta);
        }
        this.holder = new EntityHolder(this);
        this.holder.maker = this.createEntityMaker();
        this.setRunner(this.runner);
        this.setExecutor(this.executor);
    }

    public void execute(Sql ... sqls) {
        for (Sql sql : sqls) {
            this.expert.formatQuery(sql);
        }
        this._exec(sqls);
    }

    public void run(ConnCallback callback) {
        this.runner.run(this.dataSource, callback);
    }

    protected int _exec(DaoStatement ... sts) {
        boolean isAllSelect = true;
        for (DaoStatement st : sts) {
            if (st.isSelect()) continue;
            isAllSelect = false;
            break;
        }
        DaoExec callback = new DaoExec(sts);
        boolean useTrans = false;
        switch (this.meta.getType()) {
            case PSQL: {
                useTrans = true;
                break;
            }
            case SQLITE: {
                Transaction t = Trans.get();
                useTrans = t != null && (t.getLevel() == 8 || t.getLevel() == 1);
                break;
            }
            default: {
                boolean bl = useTrans = !Trans.isTransactionNone() || sts.length != 1 && !isAllSelect;
            }
        }
        if (!useTrans) {
            this.run(callback);
        } else {
            Trans.exec(this.autoTransLevel, callback);
        }
        return callback.re;
    }

    protected EntityMaker createEntityMaker() {
        return new AnnotationEntityMaker(this.dataSource, this.expert, this.holder);
    }

    public PojoMaker pojoMaker() {
        return this.pojoMaker;
    }

    public void setAutoTransLevel(int autoTransLevel) {
        this.autoTransLevel = autoTransLevel;
    }

    protected class DaoExec
    implements Atom,
    ConnCallback {
        private DaoStatement[] sts;
        private int re;

        public DaoExec(DaoStatement ... sts) {
            this.sts = sts;
        }

        @Override
        public void run() {
            DaoSupport.this.run(this);
        }

        @Override
        public void invoke(Connection conn) throws Exception {
            for (DaoStatement st : this.sts) {
                if (st == null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("Found a null DaoStatement(SQL), ingore it ~~");
                    continue;
                }
                DaoSupport.this.executor.exec(conn, st);
                this.re += st.getUpdateCount();
            }
        }
    }
}

