/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.nutz.aop.ClassAgent;
import org.nutz.aop.ClassDefiner;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.MethodMatcher;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;

public abstract class AbstractClassAgent
implements ClassAgent {
    private ArrayList<Pair> pairs = new ArrayList();
    @Deprecated
    public static AtomicLong t;

    @Override
    public ClassAgent addInterceptor(MethodMatcher matcher, MethodInterceptor listener) {
        if (null != listener) {
            this.pairs.add(new Pair(matcher, listener));
        }
        return this;
    }

    @Override
    public <T> Class<T> define(ClassDefiner cd, Class<T> klass) {
        if (klass.getName().endsWith("$$NUTZAOP")) {
            return klass;
        }
        String newName = klass.getName() + (t == null ? "" : "$" + t.get()) + "$$NUTZAOP";
        return this.define(cd, klass, newName);
    }

    public <T> Class<T> define(ClassDefiner cd, Class<T> klass, String newName) {
        Class<T> newClass = this.try2Load(newName, klass.getClassLoader());
        if (newClass != null) {
            return newClass;
        }
        if (!this.checkClass(klass)) {
            return klass;
        }
        Pair2[] pair2s = this.findMatchedMethod(klass);
        if (pair2s.length == 0) {
            return klass;
        }
        Constructor<T>[] constructors = this.getEffectiveConstructors(klass);
        newClass = this.generate(cd, pair2s, newName, klass, constructors);
        return newClass;
    }

    protected abstract <T> Class<T> generate(ClassDefiner var1, Pair2[] var2, String var3, Class<T> var4, Constructor<T>[] var5);

    protected <T> Constructor<T>[] getEffectiveConstructors(Class<T> klass) {
        Constructor<?>[] constructors = klass.getDeclaredConstructors();
        ArrayList cList = new ArrayList();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (Modifier.isPrivate(constructor.getModifiers())) continue;
            cList.add(constructor);
        }
        if (cList.size() == 0) {
            throw Lang.makeThrow("No non-private constructor founded,unable to create sub-class!", new Object[0]);
        }
        return cList.toArray(new Constructor[cList.size()]);
    }

    protected <T> boolean checkClass(Class<T> klass) {
        if (klass == null) {
            return false;
        }
        String klass_name = klass.getName();
        if (klass_name.endsWith("$$NUTZAOP")) {
            return false;
        }
        if (klass.isInterface() || klass.isArray() || klass.isEnum() || klass.isPrimitive() || klass.isMemberClass() || klass.isAnnotation() || klass.isAnonymousClass()) {
            throw Lang.makeThrow("%s is NOT a Top-Class!Creation FAIL!", klass_name);
        }
        if (Modifier.isFinal(klass.getModifiers()) || Modifier.isAbstract(klass.getModifiers())) {
            throw Lang.makeThrow("%s is final or abstract!Creation FAIL!", klass_name);
        }
        return true;
    }

    protected <T> Class<T> try2Load(String newName, ClassLoader loader) {
        try {
            if (loader == null) {
                return this.getClass().getClassLoader().loadClass(newName);
            }
            return loader.loadClass(newName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private <T> Pair2[] findMatchedMethod(Class<T> klass) {
        Method[] all = Mirror.me(klass).getAllDeclaredMethodsWithoutTop();
        ArrayList<Pair2> p2 = new ArrayList<Pair2>();
        for (Method m : all) {
            int mod = m.getModifiers();
            if (mod == 0 || Modifier.isStatic(mod) || Modifier.isPrivate(mod) || Modifier.isFinal(mod) || Modifier.isAbstract(mod)) continue;
            ArrayList<MethodInterceptor> mls = new ArrayList<MethodInterceptor>();
            for (Pair p : this.pairs) {
                if (!p.matcher.match(m)) continue;
                mls.add(p.listener);
            }
            if (mls.size() <= 0) continue;
            p2.add(new Pair2(m, mls));
        }
        return p2.toArray(new Pair2[p2.size()]);
    }

    protected static class Pair2 {
        public Method method;
        public ArrayList<MethodInterceptor> listeners;

        Pair2(Method method, ArrayList<MethodInterceptor> listeners) {
            this.method = method;
            this.listeners = listeners;
        }
    }

    protected static class Pair {
        MethodMatcher matcher;
        MethodInterceptor listener;

        Pair(MethodMatcher matcher, MethodInterceptor listener) {
            this.matcher = matcher;
            this.listener = listener;
        }
    }
}

