/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.trans;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.nutz.lang.ComboException;
import org.nutz.trans.Transaction;

public class NutTransaction
extends Transaction {
    private static AtomicLong TransIdMaker = new AtomicLong();
    private List<ConnInfo> list = new ArrayList<ConnInfo>();
    private long id = TransIdMaker.getAndIncrement();

    @Override
    protected void commit() {
        ComboException ce = new ComboException();
        for (ConnInfo cInfo : this.list) {
            try {
                cInfo.conn.commit();
                if (cInfo.conn.getTransactionIsolation() == cInfo.oldLevel) continue;
                cInfo.conn.setTransactionIsolation(cInfo.oldLevel);
            }
            catch (SQLException e) {
                ce.add(e);
            }
        }
        if (null != ce.getCause()) {
            throw ce;
        }
    }

    @Override
    public Connection getConnection(DataSource dataSource) throws SQLException {
        for (ConnInfo p : this.list) {
            if (p.ds != dataSource) continue;
            return p.conn;
        }
        Connection conn = dataSource.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        this.list.add(new ConnInfo(dataSource, conn, this.getLevel()));
        return conn;
    }

    @Override
    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ComboException ce = new ComboException();
        for (ConnInfo cInfo : this.list) {
            try {
                if (cInfo.conn.isClosed() || cInfo.conn.getTransactionIsolation() == cInfo.oldLevel) continue;
                cInfo.conn.setTransactionIsolation(cInfo.oldLevel);
            }
            catch (Throwable e) {}
            continue;
            finally {
                try {
                    cInfo.conn.close();
                }
                catch (Exception e) {
                    ce.add(e);
                }
            }
        }
        this.list.clear();
    }

    @Override
    protected void rollback() {
        for (ConnInfo cInfo : this.list) {
            try {
                cInfo.conn.rollback();
            }
            catch (Throwable throwable) {}
        }
    }

    private static class ConnInfo {
        DataSource ds;
        Connection conn;
        int oldLevel;

        ConnInfo(DataSource ds, Connection conn, int level) throws SQLException {
            this.ds = ds;
            this.conn = conn;
            this.oldLevel = conn.getTransactionIsolation();
            if (this.oldLevel != level) {
                conn.setTransactionIsolation(level);
            }
        }
    }
}

