/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.lang.util.Disks;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.nutz.resource.impl.FileResource;
import org.nutz.resource.impl.ResourceLocation;

class FileSystemResourceLocation
extends ResourceLocation {
    File root;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemResourceLocation other = (FileSystemResourceLocation)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    @Override
    public void scan(String base, Pattern pattern, List<NutResource> list) {
        File baseFile = new File(this.root.getAbsolutePath() + "/" + base);
        if (baseFile.isFile()) {
            list.add(new FileResource(baseFile));
            return;
        }
        Disks.visitFile(baseFile, new Scans.ResourceFileVisitor(list, base), new Scans.ResourceFileFilter(pattern));
    }

    public String toString() {
        return "FileSystemResourceLocation [root=" + this.root + "]";
    }

    public FileSystemResourceLocation(File root) {
        this.root = root;
    }
}

