/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugin;

import java.util.ArrayList;
import java.util.List;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocException;
import org.nutz.plugin.NoPluginCanWorkException;
import org.nutz.plugin.Plugin;
import org.nutz.plugin.PluginManager;

public class IocPluginManager<T>
implements PluginManager<T> {
    private Ioc ioc;
    private String[] names;

    public IocPluginManager(Ioc ioc, String ... names) {
        this.ioc = ioc;
        this.names = names;
    }

    @Override
    public T get() throws NoPluginCanWorkException {
        for (String name : this.names) {
            try {
                Plugin plugin = this.ioc.get(Plugin.class, name);
                if (!plugin.canWork()) continue;
                return (T)plugin;
            }
            catch (IocException e) {
                // empty catch block
            }
        }
        throw new NoPluginCanWorkException();
    }

    @Override
    public List<T> gets() {
        ArrayList<Plugin> aList = new ArrayList<Plugin>(this.names.length);
        for (String name : this.names) {
            try {
                Plugin plugin = this.ioc.get(Plugin.class, name);
                if (!plugin.canWork()) continue;
                aList.add(plugin);
            }
            catch (IocException e) {
                // empty catch block
            }
        }
        return aList;
    }
}

