/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.view.RawView;

public class RawView2
extends RawView {
    private static final Log log = Logs.get();
    protected DataInputStream in;
    protected int maxLen;

    public RawView2(String contentType, InputStream in, int maxLen) {
        super(contentType);
        this.in = new DataInputStream(in);
        this.maxLen = maxLen;
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        if (resp.getContentType() == null) {
            resp.setContentType(this.contentType);
        }
        resp.addHeader("Connection", "close");
        String rangeStr = req.getHeader("Range");
        if (rangeStr == null) {
            resp.setContentLength(this.maxLen);
            Streams.writeAndClose((OutputStream)resp.getOutputStream(), this.in);
            return;
        }
        ArrayList<RawView.RangeRange> rs = new ArrayList<RawView.RangeRange>();
        if (!RawView2.parseRange(rangeStr, rs, this.maxLen)) {
            resp.setStatus(416);
            return;
        }
        if (rs.size() != 1) {
            log.info("multipart/byteranges is NOT support yet");
            resp.setStatus(416);
            return;
        }
        long totolSize = 0L;
        for (RawView.RangeRange rangeRange : rs) {
            totolSize += rangeRange.end - rangeRange.start;
        }
        resp.setStatus(206);
        resp.setHeader("Content-Length", "" + totolSize);
        resp.setHeader("Accept-Ranges", "bytes");
        RawView.RangeRange rangeRange = (RawView.RangeRange)rs.get(0);
        resp.setHeader("Content-Range", String.format("bytes %d-%d/%d", rangeRange.start, rangeRange.end - 1L, this.maxLen));
        ServletOutputStream out = resp.getOutputStream();
        RawView2.writeDownloadRange(this.in, (OutputStream)out, rangeRange);
        out.close();
    }
}

