/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Lang;
import org.nutz.mvc.View;

public class HttpStatusView
implements View {
    public static final View HTTP_404 = new HttpStatusView(404);
    public static final View HTTP_500 = new HttpStatusView(500);
    public static final View HTTP_502 = new HttpStatusView(502);
    private int statusCode;

    public HttpStatusView(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) {
        int code = this.statusCode;
        if (obj != null && obj instanceof HttpStatusException) {
            code = ((HttpStatusException)obj).getStatus();
        }
        if (code >= 400) {
            try {
                resp.sendError(code);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        } else {
            resp.setStatus(code);
        }
    }

    public static class HttpStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 4035188583429445028L;
        private int status;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public HttpStatusException(int status) {
            this.status = status;
        }

        public HttpStatusException(int status, String fmt, Object ... args) {
            super(String.format(fmt, args));
            this.status = status;
        }
    }
}

