/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.view.AbstractPathView;

public class ForwardView
extends AbstractPathView {
    public ForwardView(String dest) {
        super(dest == null ? null : dest.replace('\\', '/'));
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Exception {
        String path = this.evalPath(req, obj);
        String args = "";
        if (path != null && path.contains("?")) {
            args = path.substring(path.indexOf(63));
            path = path.substring(0, path.indexOf(63));
        }
        String ext = this.getExt();
        if (Strings.isBlank(path)) {
            path = Mvcs.getRequestPath(req);
            path = "/WEB-INF" + (path.startsWith("/") ? "" : "/") + Files.renameSuffix(path, ext);
        } else if (path.charAt(0) == '/') {
            if (!path.toLowerCase().endsWith(ext)) {
                path = path + ext;
            }
        } else {
            path = "/WEB-INF/" + path.replace('.', '/') + ext;
        }
        path = path + args;
        RequestDispatcher rd = req.getRequestDispatcher(path);
        if (rd == null) {
            throw Lang.makeThrow("Fail to find Forward '%s'", path);
        }
        rd.forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected String getExt() {
        return "";
    }
}

