/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.session;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.mvc.SessionProvider;

public abstract class AbstractSessionProvider
implements SessionProvider {
    private static final Object lock = new Object();

    @Override
    public HttpServletRequest filter(HttpServletRequest req, HttpServletResponse resp, ServletContext servletContext) {
        return new SessionProviderHttpServletRequestWrapper(req, resp, servletContext);
    }

    public abstract HttpSession createSession(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3);

    @Override
    public void notifyStop() {
    }

    public class SessionProviderHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        protected HttpSession session;
        protected HttpServletRequest req;
        protected HttpServletResponse resp;
        protected ServletContext servletContext;

        public SessionProviderHttpServletRequestWrapper(HttpServletRequest req, HttpServletResponse resp, ServletContext servletContext) {
            super(req);
            this.req = req;
            this.resp = resp;
            this.servletContext = servletContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpSession getSession(boolean create) {
            if (create && this.session == null) {
                Object object = lock;
                synchronized (object) {
                    if (this.session == null) {
                        this.session = AbstractSessionProvider.this.createSession(this.req, this.resp, this.servletContext);
                    }
                }
            }
            return this.session;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }
    }
}

