/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.AbstractAdaptor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.injector.ArrayInjector;
import org.nutz.mvc.adaptor.injector.MapPairInjector;
import org.nutz.mvc.adaptor.injector.NameInjector;
import org.nutz.mvc.adaptor.injector.ObjectNavlPairInjector;
import org.nutz.mvc.adaptor.injector.ObjectPairInjector;
import org.nutz.mvc.annotation.Param;

public class PairAdaptor
extends AbstractAdaptor {
    private static final Log log = Logs.get();

    @Override
    protected ParamInjector evalInjectorBy(Type type, Param param) {
        Class<?> clazz = Lang.getTypeClass(type);
        if (clazz == null) {
            if (log.isWarnEnabled()) {
                log.warnf("!!Fail to get Type Class : type=%s , param=%s", type, param);
            }
            return null;
        }
        Type[] paramTypes = null;
        if (type instanceof ParameterizedType) {
            paramTypes = ((ParameterizedType)type).getActualTypeArguments();
        }
        if (null == param) {
            return null;
        }
        String defaultValue = null;
        if (param.df() != null && !"//NOT EXIST IN//".equals(param.df())) {
            defaultValue = param.df();
        }
        String pm = param.value();
        String datefmt = param.dfmt();
        if ("..".equals(pm)) {
            if (Map.class.isAssignableFrom(clazz)) {
                return new MapPairInjector(type);
            }
            return new ObjectPairInjector(null, type);
        }
        if (pm.startsWith("::") && pm.length() > 2) {
            return new ObjectNavlPairInjector(pm.substring(2), type);
        }
        if (clazz.isArray()) {
            return new ArrayInjector(pm, null, type, paramTypes, defaultValue);
        }
        return this.getNameInjector(pm, datefmt, type, paramTypes, defaultValue);
    }

    protected ParamInjector getNameInjector(String pm, String datefmt, Type type, Type[] paramTypes, String defaultValue) {
        return new NameInjector(pm, datefmt, type, paramTypes, defaultValue);
    }
}

