/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mapl.impl.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.nutz.castor.Castors;
import org.nutz.el.El;
import org.nutz.json.Json;
import org.nutz.json.entity.JsonEntity;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.Context;
import org.nutz.mapl.Mapl;
import org.nutz.mapl.MaplConvert;

public class ObjConvertImpl
implements MaplConvert {
    Stack<String> path = new Stack();
    Context context = Lang.context();
    private Type type;

    public ObjConvertImpl(Type type) {
        this.type = type;
    }

    @Override
    public Object convert(Object model) {
        if (model == null) {
            return null;
        }
        if (this.type == null) {
            return model;
        }
        if (!(model instanceof Map) && !(model instanceof List)) {
            return Castors.me().castTo(model, Lang.getTypeClass(this.type));
        }
        return this.inject(model, this.type);
    }

    Object inject(Object model, Type type) {
        if (model == null) {
            return null;
        }
        Mirror me = Mirror.me(type);
        Object obj = null;
        obj = Collection.class.isAssignableFrom(me.getType()) ? this.injectCollection(model, me) : (Map.class.isAssignableFrom(me.getType()) ? this.injectMap(model, me) : (me.getType().isArray() ? this.injectArray(model, me) : this.injectObj(model, me)));
        if (this.path.size() > 0) {
            this.path.pop();
        }
        return obj;
    }

    private Object injectArray(Object model, Mirror<?> me) {
        Class<?> clazz = me.getType().getComponentType();
        List list = (List)model;
        ArrayList<Object> vals = new ArrayList<Object>();
        int j = 0;
        for (Object obj : list) {
            if (this.isLeaf(obj)) {
                vals.add(Castors.me().castTo(obj, clazz));
                continue;
            }
            this.path.push("a" + j++);
            vals.add(this.inject(obj, clazz));
        }
        Object obj = Array.newInstance(clazz, vals.size());
        for (int i = 0; i < vals.size(); ++i) {
            Array.set(obj, i, vals.get(i));
        }
        return obj;
    }

    private Object injectMap(Object model, Mirror<?> me) {
        Map re = null;
        re = me.isInterface() ? new LinkedHashMap() : (Map)me.born(new Object[0]);
        Map map = (Map)model;
        if (me.getGenericsTypes() == null) {
            re.putAll(map);
            return re;
        }
        Type type = me.getGenericsType(1);
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (!this.isLeaf(key)) {
                key = this.inject(key, me.getGenericsType(0));
            }
            if (this.isLeaf(val)) {
                re.put(key, Castors.me().castTo(val, Lang.getTypeClass(type)));
                continue;
            }
            this.path.push(key.toString());
            re.put(key, this.inject(val, type));
        }
        return re;
    }

    private Object injectCollection(Object model, Mirror<?> me) {
        if (!(model instanceof Collection)) {
            throw Lang.makeThrow("Not a Collection --> " + model.getClass(), new Object[0]);
        }
        Collection re = null;
        re = !me.isInterface() ? (Collection)me.born(new Object[0]) : this.makeCollection(me);
        if (me.getGenericsTypes() == null) {
            re.addAll((Collection)model);
            return re;
        }
        Type type = me.getGenericsType(0);
        int j = 0;
        for (Object obj : (Collection)model) {
            if (this.isLeaf(obj)) {
                re.add(Castors.me().castTo(obj, Lang.getTypeClass(type)));
                continue;
            }
            this.path.push("a" + j++);
            re.add(this.inject(obj, type));
        }
        return re;
    }

    private Collection makeCollection(Mirror<?> me) {
        if (List.class.isAssignableFrom(me.getType())) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(me.getType())) {
            return new HashSet();
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b!");
    }

    private Object injectObj(Object model, Mirror<?> mirror) {
        if (mirror.getType() == Object.class) {
            return model;
        }
        Object obj = mirror.born(new Object[0]);
        this.context.set(this.fetchPath(), obj);
        Map map = (Map)model;
        JsonEntity jen = Json.getEntity(mirror);
        for (String key : map.keySet()) {
            Object val;
            JsonEntityField jef = jen.getField(key);
            if (jef == null || (val = map.get(jef.getName())) == null) continue;
            if (this.isLeaf(val)) {
                if (val instanceof El) {
                    val = ((El)val).eval(this.context);
                }
                jef.setValue(obj, Mapl.maplistToObj(val, jef.getGenericType()));
                continue;
            }
            this.path.push(key);
            jef.setValue(obj, Mapl.maplistToObj(val, jef.getGenericType()));
        }
        return obj;
    }

    private boolean isLeaf(Object obj) {
        if (obj instanceof Map) {
            return false;
        }
        return !(obj instanceof List);
    }

    private String fetchPath() {
        StringBuffer sb = new StringBuffer();
        sb.append("root");
        for (String item : this.path) {
            if (item.charAt(0) != 'a') {
                sb.append("m");
            }
            sb.append(item);
        }
        return sb.toString();
    }
}

