/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.Context;

public abstract class AbstractContext
implements Context {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object get(String name, Object dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return obj;
    }

    @Override
    public <T> T getAs(Class<T> type, String name) {
        return Castors.me().castTo(this.get(name), type);
    }

    @Override
    public <T> T getAs(Class<T> type, String name, T dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return Castors.me().castTo(obj, type);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double getDouble(String name, double dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return Double.parseDouble(obj.toString());
    }

    @Override
    public int getInt(String name, int dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return Integer.parseInt(obj.toString());
    }

    @Override
    public String getString(String name, String dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(String name, boolean dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    @Override
    public float getFloat(String name, float dft) {
        Object obj = this.get(name);
        if (null == obj) {
            return dft;
        }
        return Float.parseFloat(obj.toString());
    }

    @Override
    public Context putAll(Object obj) {
        return this.putAll(null, obj);
    }

    @Override
    public Context putAll(String prefix, Object obj) {
        block6: {
            block8: {
                block7: {
                    if (null == obj) break block6;
                    if (!(obj instanceof Context)) break block7;
                    for (String key : ((Context)obj).keys()) {
                        if (null != prefix) {
                            key = prefix + key;
                        }
                        this.set(key, ((Context)obj).get(key));
                    }
                    break block6;
                }
                if (!(obj instanceof Map)) break block8;
                for (Map.Entry en : ((Map)obj).entrySet()) {
                    Object oKey = en.getKey();
                    if (null == oKey) continue;
                    String key = oKey.toString();
                    if (null != prefix) {
                        key = prefix + key;
                    }
                    this.set(key.toString(), en.getValue());
                }
                break block6;
            }
            Mirror<Object> mirror = Mirror.me(obj);
            if (mirror.getType().isArray() || mirror.isNumber() || mirror.isBoolean() || mirror.isChar() || mirror.isStringLike() || mirror.isDateTimeLike() || Collection.class.isAssignableFrom(mirror.getType())) break block6;
            for (Field field : mirror.getFields()) {
                String key = field.getName();
                if (null != prefix) {
                    key = prefix + key;
                }
                this.set(key, mirror.getValue(obj, field));
            }
        }
        return this;
    }

    @Override
    public Map<String, Object> getInnerMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.keys()) {
            map.put(key, this.get(key));
        }
        return map;
    }

    @Override
    public Map<String, Object> getMap(String name) {
        return this.getAs(Map.class, name);
    }

    @Override
    public List<Object> getList(String name) {
        return this.getAs(List.class, name);
    }

    @Override
    public <T> List<T> getList(Class<T> classOfT, String name) {
        return this.getList(name);
    }

    @Override
    public abstract AbstractContext clone();
}

