/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Mirror;
import org.nutz.lang.reflect.FastClass;

public abstract class AbstractFastClass
implements FastClass {
    private static final String[] cMethodName = new String[]{"create", "newInstance"};

    private static final Class<?>[] toClasses(Object ... args) {
        Class[] classes = new Class[args.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = args[i].getClass();
        }
        return classes;
    }

    protected Object _born(int index, Object ... args) {
        throw Lang.noImplement();
    }

    protected Object _invoke(Object obj, int index, Object ... args) {
        throw Lang.noImplement();
    }

    @Override
    public Object born(Constructor<?> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("!!Constructor must not NULL !");
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            throw new IllegalArgumentException("!!Constructor is private !");
        }
        return this._born(this.getConstructorIndex(constructor.getParameterTypes()), args);
    }

    @Override
    public Object born(Object ... args) {
        Class<?>[] classes = AbstractFastClass.toClasses(args);
        int index = this.getConstructorIndex(classes);
        if (index > -1) {
            return this._born(this.getConstructorIndex(classes), args);
        }
        for (int i = 0; i < cMethodName.length; ++i) {
            try {
                Method method = this.getSrcClass().getDeclaredMethod(cMethodName[i], classes);
                if (Modifier.isPrivate(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || !this.getSrcClass().isAssignableFrom(method.getReturnType())) continue;
                return this.invoke(null, method, args);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("!!Fail to find Constructor for args");
    }

    private int getConstructorIndex(Class<?>[] cpB) {
        Constructor<?>[] constructors = this.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] cpA = constructors[i].getParameterTypes();
            if (MatchType.YES != Mirror.matchParamTypes(cpA, cpB)) continue;
            return i;
        }
        throw new RuntimeException("!!No such Constructor found!");
    }

    protected abstract Constructor<?>[] getConstructors();

    private int getMethodIndex(Method method) {
        for (int i = 0; i < this.getMethods().length; ++i) {
            if (this.getMethods()[i].equals(method)) {
                return i;
            }
            if (!this.getMethods()[i].getName().equals(method.getName()) || MatchType.YES != Mirror.matchParamTypes(this.getMethods()[i].getParameterTypes(), method.getParameterTypes())) continue;
            return i;
        }
        throw new RuntimeException("!!No such Method found!");
    }

    private int getMethodIndex(String name, Class<?>[] cpB) {
        for (int i = 0; i < this.getMethods().length; ++i) {
            if (!this.getMethods()[i].getName().equals(name) || MatchType.YES != Mirror.matchParamTypes(this.getMethods()[i].getParameterTypes(), cpB)) continue;
            return i;
        }
        throw new RuntimeException("!!No such Method found!");
    }

    protected abstract Method[] getMethods();

    protected abstract Class<?> getSrcClass();

    @Override
    public Object invoke(Object obj, Method method, Object ... args) {
        if (method == null) {
            throw new IllegalArgumentException("!!Method must not NULL !");
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new IllegalArgumentException("!!Method is private !");
        }
        if (obj == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("!!obj is NULL but Method isn't static !");
        }
        int index = this.getMethodIndex(method);
        if (index > -1) {
            return this._invoke(obj, this.getMethodIndex(method), args);
        }
        throw new IllegalArgumentException("!!No such method --> " + method);
    }

    @Override
    public Object invoke(Object obj, String methodName, Object ... args) {
        Class<?>[] classes = AbstractFastClass.toClasses(args);
        int index = this.getMethodIndex(methodName, classes);
        if (index > -1) {
            return this._invoke(obj, index, args);
        }
        throw new IllegalArgumentException("!!Fail to get method ! For " + Json.toJson(classes));
    }
}

