/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.stream.StringOutputStream;

public abstract class Dumps {
    public static String matcher(Matcher m) {
        if (m.find()) {
            return Dumps.matcherFound(m);
        }
        return "No found!";
    }

    public static String matcherFound(Matcher m) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= m.groupCount(); ++i) {
            sb.append(String.format("%2d: %s\n", i, m.group(i)));
        }
        return sb.toString();
    }

    public static String obj(Object obj) {
        if (null == obj) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(obj.getClass().getName() + "\n\n[Fields:]");
        Mirror<Class<?>> mirror = Mirror.me(obj.getClass());
        for (Field field : mirror.getType().getFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            try {
                sb.append(String.format("\n\t%10s : %s", field.getName(), field.get(obj)));
            }
            catch (Exception e1) {
                sb.append(String.format("\n\t%10s : %s", field.getName(), e1.getMessage()));
            }
        }
        sb.append("\n\n[Methods:]");
        for (AccessibleObject accessibleObject : mirror.getType().getMethods()) {
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getParameterTypes().length != 0) continue;
            try {
                sb.append(String.format("\n\t%10s : %s", ((Method)accessibleObject).getName(), ((Method)accessibleObject).invoke(obj, new Object[0])));
            }
            catch (Exception e) {
                sb.append(String.format("\n\t%10s : %s", ((Method)accessibleObject).getName(), e.getMessage()));
            }
        }
        return sb.toString();
    }

    public static class HTTP {
        public static void http(HttpServletRequest req, OutputStream ops, MODE mode) {
            try {
                int b;
                Object ins;
                if (MODE.ALL == mode || MODE.HEADER_ONLY == mode) {
                    StringBuilder sb = new StringBuilder();
                    Enumeration ens = req.getHeaderNames();
                    while (ens.hasMoreElements()) {
                        String name = ens.nextElement().toString();
                        sb.append(name).append(": ").append(req.getHeader(name)).append("\r\n");
                    }
                    sb.append("\r\n");
                    ins = Lang.ins(sb);
                    while (-1 != (b = ((InputStream)ins).read())) {
                        ops.write(b);
                    }
                }
                if (MODE.ALL == mode || MODE.BODY_ONLY == mode) {
                    ins = req.getInputStream();
                    while (-1 != (b = ((InputStream)ins).read())) {
                        ops.write(b);
                    }
                    ((InputStream)ins).close();
                }
                ops.flush();
                ops.close();
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }

        public static String http(HttpServletRequest req, MODE mode) {
            StringBuilder sb = new StringBuilder();
            StringOutputStream ops = new StringOutputStream(sb, req.getCharacterEncoding());
            HTTP.http(req, ops, mode);
            return sb.toString();
        }

        public static void body(HttpServletRequest req, OutputStream ops) {
            HTTP.http(req, ops, MODE.BODY_ONLY);
        }

        public static String body(HttpServletRequest req) {
            return HTTP.http(req, MODE.BODY_ONLY);
        }

        public static void header(HttpServletRequest req, OutputStream ops) {
            HTTP.http(req, ops, MODE.HEADER_ONLY);
        }

        public static String header(HttpServletRequest req) {
            return HTTP.http(req, MODE.HEADER_ONLY);
        }

        public static void all(HttpServletRequest req, OutputStream ops) {
            HTTP.http(req, ops, MODE.ALL);
        }

        public static String all(HttpServletRequest req) {
            return HTTP.http(req, MODE.ALL);
        }

        public static enum MODE {
            ALL,
            HEADER_ONLY,
            BODY_ONLY;

        }
    }
}

