/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlIocLoader
implements IocLoader {
    private static final Log LOG = Logs.get();
    protected Map<String, IocObject> iocMap = new LinkedHashMap<String, IocObject>();
    protected Map<String, String> parentMap = new TreeMap<String, String>();
    protected static final String TAG_OBJ = "obj";
    protected static final String TAG_ARGS = "args";
    protected static final String TAG_FIELD = "field";
    protected static final String TAG_FACTORY = "factory";
    private static int innerId;
    protected static final String STR_TAG = "str";
    protected static final String ARRAY_TAG = "array";
    protected static final String MAP_TAG = "map";
    protected static final String ITEM_TAG = "item";
    protected static final String LIST_TAG = "list";
    protected static final String SET_TAG = "set";
    protected static final String OBJ_TAG = "obj";
    protected static final String INT_TAG = "int";
    protected static final String SHORT_TAG = "short";
    protected static final String LONG_TAG = "long";
    protected static final String FLOAT_TAG = "float";
    protected static final String DOUBLE_TAG = "double";
    protected static final String BOOLEAN_TAG = "bool";
    protected static final String REFER_TAG = "refer";
    protected static final String JAVA_TAG = "java";
    protected static final String FILE_TAG = "file";
    protected static final String EVN_TAG = "env";
    protected static final String JNDI_TAG = "jndi";
    protected static final String SYS_TAG = "sys";
    protected static final String APP_TAG = "app";

    public XmlIocLoader(String ... fileNames) {
        try {
            DocumentBuilder builder = Lang.xmls();
            List<NutResource> list = Scans.me().loadResource(this.getScanPatten(), fileNames);
            for (NutResource nr : list) {
                InputStream ins = nr.getInputStream();
                Document document = builder.parse(ins);
                document.normalizeDocument();
                NodeList nodeListZ = document.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodeListZ.getLength(); ++i) {
                    if (!(nodeListZ.item(i) instanceof Element)) continue;
                    this.paserBean((Element)nodeListZ.item(i), false);
                }
                Streams.safeClose(ins);
            }
            this.handleParent();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Load complete :\n%s", Json.toJson(this.iocMap));
            }
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
    }

    @Override
    public String[] getName() {
        return this.iocMap.keySet().toArray(new String[this.iocMap.keySet().size()]);
    }

    @Override
    public boolean has(String name) {
        return this.iocMap.containsKey(name);
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        if (this.has(name)) {
            return this.iocMap.get(name);
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    protected String paserBean(Element beanElement, boolean innerBean) throws Throwable {
        String factory;
        String beanParent;
        String beanScope;
        String beanId;
        if (innerBean) {
            beanId = "inner$" + innerId;
            ++innerId;
        } else {
            beanId = beanElement.getAttribute("name");
        }
        if (beanId == null) {
            throw Lang.makeThrow("No name for one bean!", new Object[0]);
        }
        if (this.iocMap.containsKey(beanId)) {
            throw Lang.makeThrow("Name of bean is not unique! name=" + beanId, new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Resolving bean define, name = %s", beanId);
        }
        IocObject iocObject = new IocObject();
        String beanType = beanElement.getAttribute("type");
        if (!Strings.isBlank(beanType)) {
            iocObject.setType(Lang.loadClass(beanType));
        }
        if (!Strings.isBlank(beanScope = beanElement.getAttribute("scope"))) {
            iocObject.setScope(beanScope);
        }
        if (!Strings.isBlank(beanParent = beanElement.getAttribute("parent"))) {
            this.parentMap.put(beanId, beanParent);
        }
        if (!Strings.isBlank(factory = beanElement.getAttribute(TAG_FACTORY))) {
            iocObject.setFactory(factory);
        }
        this.parseArgs(beanElement, iocObject);
        this.parseFields(beanElement, iocObject);
        this.parseEvents(beanElement, iocObject);
        this.iocMap.put(beanId, iocObject);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Resolved bean define, name = %s", beanId);
        }
        return beanId;
    }

    protected void parseArgs(Element beanElement, IocObject iocObject) throws Throwable {
        List<Element> list = this.getChildNodesByTagName(beanElement, TAG_ARGS);
        if (list.size() > 0) {
            Element argsElement = list.get(0);
            NodeList argNodeList = argsElement.getChildNodes();
            for (int i = 0; i < argNodeList.getLength(); ++i) {
                if (!(argNodeList.item(i) instanceof Element)) continue;
                iocObject.addArg(this.parseX((Element)argNodeList.item(i)));
            }
        }
    }

    protected void parseFields(Element beanElement, IocObject iocObject) throws Throwable {
        List<Element> list = this.getChildNodesByTagName(beanElement, TAG_FIELD);
        for (Element fieldElement : list) {
            IocField iocField = new IocField();
            iocField.setName(fieldElement.getAttribute("name"));
            if ("true".equals(fieldElement.getAttribute("optional"))) {
                iocField.setOptional(true);
            }
            if (fieldElement.hasChildNodes()) {
                NodeList nodeList = fieldElement.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    if (!(nodeList.item(j) instanceof Element)) continue;
                    iocField.setValue(this.parseX((Element)nodeList.item(j)));
                    break;
                }
            }
            iocObject.addField(iocField);
        }
    }

    protected IocValue parseX(Element element) throws Throwable {
        IocValue iocValue = new IocValue();
        String type = element.getNodeName();
        if (EVN_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(EVN_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (SYS_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(SYS_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (JNDI_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(JNDI_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (JAVA_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(JAVA_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (REFER_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(REFER_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (FILE_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(FILE_TAG);
            iocValue.setValue(element.getTextContent());
        } else if (APP_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(APP_TAG);
            iocValue.setValue(element.getTextContent());
        } else if ("obj".equalsIgnoreCase(type)) {
            iocValue.setType(REFER_TAG);
            iocValue.setValue(this.paserBean(element, true));
        } else if (MAP_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(null);
            iocValue.setValue(this.paserMap(element));
        } else if (LIST_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(null);
            iocValue.setValue(this.paserCollection(element));
        } else if (ARRAY_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(null);
            iocValue.setValue(this.paserCollection(element).toArray());
        } else if (SET_TAG.equalsIgnoreCase(type)) {
            iocValue.setType(null);
            HashSet<IocValue> set = new HashSet<IocValue>();
            set.addAll(this.paserCollection(element));
            iocValue.setValue(set);
        } else {
            iocValue.setType(null);
            if (element.getFirstChild() != null) {
                iocValue.setValue(element.getFirstChild().getTextContent());
            }
        }
        return iocValue;
    }

    protected List<IocValue> paserCollection(Element element) throws Throwable {
        ArrayList<IocValue> list = new ArrayList<IocValue>();
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                list.add(this.parseX((Element)node));
            }
        }
        return list;
    }

    protected Map<String, ?> paserMap(Element element) throws Throwable {
        HashMap<String, IocValue> map = new HashMap<String, IocValue>();
        if (element.hasChildNodes()) {
            List<Element> elist = this.getChildNodesByTagName(element, ITEM_TAG);
            for (Element elementItem : elist) {
                String key = elementItem.getAttribute("key");
                if (map.containsKey(key)) {
                    throw new IllegalArgumentException("key is not unique!");
                }
                NodeList list = elementItem.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    if (!(list.item(j) instanceof Element)) continue;
                    map.put(key, this.parseX((Element)list.item(j)));
                    break;
                }
                if (map.containsKey(key)) continue;
                map.put(key, null);
            }
        }
        return map;
    }

    protected void parseEvents(Element beanElement, IocObject iocObject) {
        List<Element> elist = this.getChildNodesByTagName(beanElement, "events");
        if (elist.size() > 0) {
            Element eventsElement = elist.get(0);
            IocEventSet iocEventSet = new IocEventSet();
            elist = this.getChildNodesByTagName(eventsElement, "fetch");
            if (elist.size() > 0) {
                iocEventSet.setFetch(elist.get(0).getTextContent());
            }
            if ((elist = this.getChildNodesByTagName(eventsElement, "create")).size() > 0) {
                iocEventSet.setCreate(elist.get(0).getTextContent());
            }
            if ((elist = this.getChildNodesByTagName(eventsElement, "depose")).size() > 0) {
                iocEventSet.setDepose(elist.get(0).getTextContent());
            }
            if (iocEventSet.getCreate() == null && iocEventSet.getDepose() == null && iocEventSet.getFetch() == null) {
                return;
            }
            iocObject.setEvents(iocEventSet);
        }
    }

    protected void handleParent() {
        for (String string : this.parentMap.values()) {
            if (this.iocMap.containsKey(string)) continue;
            throw Lang.makeThrow("\u53d1\u73b0\u65e0\u6548\u7684parent=%s", string);
        }
        ArrayList<String> parentList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.parentMap.entrySet()) {
            if (!this.check(parentList, entry.getKey())) {
                throw Lang.makeThrow("\u53d1\u73b0\u5faa\u73af\u4f9d\u8d56! bean id=%s", entry.getKey());
            }
            parentList.clear();
        }
        while (this.parentMap.size() != 0) {
            Iterator<Map.Entry<String, String>> iterator = this.parentMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry;
                entry = iterator.next();
                String beanId = entry.getKey();
                String parentId = entry.getValue();
                if (this.parentMap.get(parentId) != null) continue;
                IocObject newIocObject = Iocs.mergeWith(this.iocMap.get(beanId), this.iocMap.get(parentId));
                this.iocMap.put(beanId, newIocObject);
                iterator.remove();
            }
        }
    }

    protected boolean check(List<String> parentList, String currentBeanId) {
        if (parentList.contains(currentBeanId)) {
            return false;
        }
        String parentBeanId = this.parentMap.get(currentBeanId);
        if (parentBeanId == null) {
            return true;
        }
        parentList.add(currentBeanId);
        return this.check(parentList, parentBeanId);
    }

    protected String getScanPatten() {
        return ".+[.]xml$";
    }

    protected List<Element> getChildNodesByTagName(Element element, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nList = element.getElementsByTagName(tagName);
        if (nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                if (!node.getParentNode().isSameNode(element) || !(node instanceof Element)) continue;
                list.add((Element)node);
            }
        }
        return list;
    }
}

