/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nutz.aop.interceptor.ioc.TransIocLoader;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.loader.annotation.AnnotationIocLoader;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.ioc.loader.xml.XmlIocLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ComboIocLoader
implements IocLoader {
    private static final Log log = Logs.get();
    private List<IocLoader> iocLoaders = new ArrayList<IocLoader>();
    private static Map<String, Class<? extends IocLoader>> loaders = new HashMap<String, Class<? extends IocLoader>>();

    public ComboIocLoader(String ... args) throws ClassNotFoundException {
        if (loaders.isEmpty()) {
            loaders.put("js", JsonLoader.class);
            loaders.put("json", JsonLoader.class);
            loaders.put("xml", XmlIocLoader.class);
            loaders.put("annotation", AnnotationIocLoader.class);
            loaders.put("anno", AnnotationIocLoader.class);
            loaders.put("trans", TransIocLoader.class);
            loaders.put("tx", TransIocLoader.class);
            try {
                loaders.put("cache", Class.forName("org.nutz.jcache.NutCacheIocLoader"));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        ArrayList<String> argsList = null;
        String currentClassName = null;
        for (String str : args) {
            if (str.length() > 0 && str.charAt(0) == '*') {
                if (argsList != null) {
                    this.createIocLoader(currentClassName, (List<String>)argsList);
                }
                currentClassName = str.substring(1);
                argsList = new ArrayList<String>();
                continue;
            }
            if (argsList == null) {
                throw new IllegalArgumentException("ioc args without Loader ClassName. " + Arrays.toString(args));
            }
            argsList.add(str);
        }
        if (currentClassName != null) {
            this.createIocLoader(currentClassName, argsList);
        }
        HashSet<String> beanNames = new HashSet<String>();
        for (IocLoader loader : this.iocLoaders) {
            for (String beanName : loader.getName()) {
                if (beanNames.add(beanName) || !log.isWarnEnabled()) continue;
                log.warnf("Found Duplicate beanName=%s, pls check you config!", beanName);
            }
        }
    }

    private void createIocLoader(String className, List<String> args) throws ClassNotFoundException {
        Class<IocLoader> klass = loaders.get(className);
        if (klass == null) {
            klass = Lang.loadClass(className);
        }
        this.iocLoaders.add((IocLoader)((Object)Mirror.me(klass).born(args.toArray(new Object[args.size()]))));
    }

    public ComboIocLoader(IocLoader ... loaders) {
        for (IocLoader iocLoader : loaders) {
            if (iocLoader == null) continue;
            this.iocLoaders.add(iocLoader);
        }
    }

    @Override
    public String[] getName() {
        ArrayList<String> list = new ArrayList<String>();
        for (IocLoader iocLoader : this.iocLoaders) {
            for (String name : iocLoader.getName()) {
                list.add(name);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean has(String name) {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            IocObject iocObject = iocLoader.load(loading, name);
            if (log.isDebugEnabled()) {
                log.debugf("Found IocObject(%s) in IocLoader(%s)", name, iocLoader.getClass().getSimpleName() + "@" + iocLoader.hashCode());
            }
            return iocObject;
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*ComboIocLoader*/\n{");
        for (IocLoader loader : this.iocLoaders) {
            String str = Json.toJson(loader);
            str = str.replaceFirst("[{]", "");
            int index = str.lastIndexOf("}");
            StringBuilder sb2 = new StringBuilder(str);
            sb2.setCharAt(index, ' ');
            sb.append((CharSequence)sb2).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

