/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.cached;

import java.util.HashMap;
import java.util.Map;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.loader.cached.CachedIocLoader;
import org.nutz.ioc.meta.IocObject;

public class CachedIocLoaderImpl
implements CachedIocLoader {
    private IocLoader proxyIocLoader;
    private Map<String, IocObject> map;

    public static CachedIocLoaderImpl create(IocLoader proxyIocLoader) {
        return new CachedIocLoaderImpl(proxyIocLoader);
    }

    private CachedIocLoaderImpl(IocLoader proxyIocLoader) {
        this.proxyIocLoader = proxyIocLoader;
        this.map = new HashMap<String, IocObject>();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String[] getName() {
        return this.proxyIocLoader.getName();
    }

    @Override
    public boolean has(String name) {
        return this.proxyIocLoader.has(name);
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        IocObject iocObject = this.map.get(name);
        if (iocObject == null) {
            iocObject = this.proxyIocLoader.load(loading, name);
            if (iocObject == null) {
                return null;
            }
            if (iocObject.isSingleton() && iocObject.getType() != null) {
                this.map.put(name, iocObject);
            }
        }
        return iocObject;
    }

    public String toString() {
        return this.proxyIocLoader.toString();
    }
}

