/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.nutz.castor.Castors;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.resource.Scans;

public class AnnotationIocLoader
implements IocLoader {
    private static final Log log = Logs.get();
    private HashMap<String, IocObject> map = new HashMap();

    public AnnotationIocLoader(String ... packages) {
        for (String packageZ : packages) {
            if (packageZ.equals("$dynamic")) {
                String[] pkgs = Strings.splitIgnoreBlank(Mvcs.ann_dynamic_path);
                if (null == pkgs) continue;
                for (String pkg : pkgs) {
                    for (Class<?> classZ : Scans.me().scanPackage(pkg)) {
                        this.addClass(classZ);
                    }
                }
                continue;
            }
            for (Class<?> classZ : Scans.me().scanPackage(packageZ)) {
                this.addClass(classZ);
            }
        }
        if (this.map.size() > 0) {
            if (log.isInfoEnabled()) {
                log.infof("Scan complete ! Found %s classes in %s base-packages!\nbeans = %s", this.map.size(), packages.length, Castors.me().castToString(this.map.keySet()));
            }
        } else {
            log.warn("NONE Annotation-Class found!! Check your configure or report a bug!! packages=" + Arrays.toString(packages));
        }
    }

    protected void addClass(Class<?> classZ) {
        block32: {
            if (classZ.isInterface() || classZ.isMemberClass() || classZ.isEnum() || classZ.isAnnotation() || classZ.isAnonymousClass()) {
                return;
            }
            int modify = classZ.getModifiers();
            if (Modifier.isAbstract(modify) || !Modifier.isPublic(modify)) {
                return;
            }
            IocBean iocBean = classZ.getAnnotation(IocBean.class);
            if (iocBean != null) {
                Method[] methods;
                Field[] fields;
                String[] args;
                String beanName;
                if (log.isDebugEnabled()) {
                    log.debugf("Found a Class with Ioc-Annotation : %s", classZ);
                }
                if (Strings.isBlank(beanName = iocBean.name())) {
                    InjectName innm = classZ.getAnnotation(InjectName.class);
                    beanName = null != innm && !Strings.isBlank(innm.value()) ? innm.value() : Strings.lowerFirst(classZ.getSimpleName());
                }
                if (this.map.containsKey(beanName)) {
                    throw Lang.makeThrow(IocException.class, "Duplicate beanName=%s, by %s !!  Have been define by %s !!", beanName, classZ, this.map.get(beanName).getClass());
                }
                IocObject iocObject = new IocObject();
                iocObject.setType(classZ);
                this.map.put(beanName, iocObject);
                iocObject.setSingleton(iocBean.singleton());
                if (!Strings.isBlank(iocBean.scope())) {
                    iocObject.setScope(iocBean.scope());
                }
                if (null != (args = iocBean.args()) && args.length > 0) {
                    for (String value : args) {
                        iocObject.addArg(this.convert(value));
                    }
                }
                IocEventSet eventSet = new IocEventSet();
                iocObject.setEvents(eventSet);
                if (!Strings.isBlank(iocBean.create())) {
                    eventSet.setCreate(iocBean.create().trim().intern());
                }
                if (!Strings.isBlank(iocBean.depose())) {
                    eventSet.setDepose(iocBean.depose().trim().intern());
                }
                if (!Strings.isBlank(iocBean.fetch())) {
                    eventSet.setFetch(iocBean.fetch().trim().intern());
                }
                ArrayList<String> fieldList = new ArrayList<String>();
                Mirror<Class<?>> mirror = Mirror.me(classZ);
                for (Field field : fields = mirror.getFields(Inject.class)) {
                    IocValue iocValue;
                    Inject inject = field.getAnnotation(Inject.class);
                    IocField iocField = new IocField();
                    iocField.setName(field.getName());
                    if (Strings.isBlank(inject.value())) {
                        iocValue = new IocValue();
                        iocValue.setType("refer");
                        iocValue.setValue(field.getName());
                    } else {
                        iocValue = this.convert(inject.value());
                    }
                    iocField.setValue(iocValue);
                    iocField.setOptional(inject.optional());
                    iocObject.addField(iocField);
                    fieldList.add(iocField.getName());
                }
                try {
                    methods = classZ.getMethods();
                }
                catch (Exception e) {
                    log.infof("Fail to call getMethods() in Class=%s, miss class or Security Limit, ignore it", classZ, e);
                    methods = new Method[]{};
                }
                catch (NoClassDefFoundError e) {
                    log.infof("Fail to call getMethods() in Class=%s, miss class or Security Limit, ignore it", classZ, e);
                    methods = new Method[]{};
                }
                for (Method method : methods) {
                    IocValue iocValue;
                    String methodName;
                    int m;
                    Inject inject = method.getAnnotation(Inject.class);
                    if (inject == null || Modifier.isAbstract(m = method.getModifiers()) || !Modifier.isPublic(m) || Modifier.isStatic(m) || !(methodName = method.getName()).startsWith("set") || methodName.length() <= 3 || method.getParameterTypes().length != 1) continue;
                    IocField iocField = new IocField();
                    iocField.setName(Strings.lowerFirst(methodName.substring(3)));
                    if (fieldList.contains(iocField.getName())) {
                        throw AnnotationIocLoader.duplicateField(classZ, iocField.getName());
                    }
                    if (Strings.isBlank(inject.value())) {
                        iocValue = new IocValue();
                        iocValue.setType("refer");
                        iocValue.setValue(Strings.lowerFirst(methodName.substring(3)));
                    } else {
                        iocValue = this.convert(inject.value());
                    }
                    iocField.setValue(iocValue);
                    iocObject.addField(iocField);
                    fieldList.add(iocField.getName());
                }
                String[] flds = iocBean.fields();
                if (flds != null && flds.length > 0) {
                    for (String fieldInfo : flds) {
                        if (fieldList.contains(fieldInfo)) {
                            throw AnnotationIocLoader.duplicateField(classZ, fieldInfo);
                        }
                        IocField iocField = new IocField();
                        if (fieldInfo.contains(":")) {
                            String[] datas = fieldInfo.split(":", 2);
                            iocField.setName(datas[0]);
                            iocField.setValue(this.convert(datas[1]));
                            iocObject.addField(iocField);
                        } else {
                            iocField.setName(fieldInfo);
                            IocValue iocValue = new IocValue();
                            iocValue.setType("refer");
                            iocValue.setValue(fieldInfo);
                            iocField.setValue(iocValue);
                            iocObject.addField(iocField);
                        }
                        fieldList.add(iocField.getName());
                    }
                }
                if (!Strings.isBlank(iocBean.factory())) {
                    iocObject.setFactory(iocBean.factory());
                }
            } else {
                try {
                    Field[] fields;
                    if (!log.isWarnEnabled()) break block32;
                    for (Field field : fields = classZ.getDeclaredFields()) {
                        if (field.getAnnotation(Inject.class) == null) continue;
                        log.warnf("class(%s) don't has @IocBean, but field(%s) has @Inject! Miss @IocBean ??", classZ.getName(), field.getName());
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected IocValue convert(String value) {
        IocValue iocValue = new IocValue();
        if (value.contains(":")) {
            iocValue.setType(value.substring(0, value.indexOf(58)));
            iocValue.setValue(value.substring(value.indexOf(58) + 1));
            if ("".equals(iocValue.getType())) {
                iocValue.setType(null);
            }
        } else {
            log.info("auto set as         refer:" + value);
            iocValue.setType("refer");
            iocValue.setValue(value);
        }
        return iocValue;
    }

    @Override
    public String[] getName() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    @Override
    public boolean has(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        if (this.has(name)) {
            return this.map.get(name);
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    private static final IocException duplicateField(Class<?> classZ, String name) {
        return Lang.makeThrow(IocException.class, "Duplicate filed defined! Class=%s,FileName=%s", classZ, name);
    }

    public String toString() {
        return "/*AnnotationIocLoader*/\n" + Json.toJson(this.map);
    }
}

