/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nutz.aop.ClassDefiner;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.asm.AsmClassAgent;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.aop.MirrorFactory;
import org.nutz.ioc.aop.config.AopConfigration;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.ioc.aop.config.impl.AnnotationAopConfigration;
import org.nutz.ioc.aop.config.impl.ComboAopConfigration;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DefaultMirrorFactory
implements MirrorFactory {
    private static final Log log = Logs.get();
    private Ioc ioc;
    private ClassDefiner cd;
    private List<AopConfigration> list;
    private static final Object lock = new Object();

    public DefaultMirrorFactory(Ioc ioc) {
        this.ioc = ioc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Mirror<T> getMirror(Class<T> type, String name) {
        if (MethodInterceptor.class.isAssignableFrom(type) || type.getName().endsWith("$$NUTZAOP") || name != null && name.startsWith("$aop") || AopConfigration.class.isAssignableFrom(type)) {
            return Mirror.me(type);
        }
        if (this.list == null) {
            ArrayList<AopConfigration> tmp = new ArrayList<AopConfigration>();
            boolean flag = true;
            Object[] names = this.ioc.getNames();
            Arrays.sort(names);
            for (Object beanName : names) {
                if (!((String)beanName).startsWith("$aop")) continue;
                AopConfigration cnf = this.ioc.get(AopConfigration.class, (String)beanName);
                tmp.add(cnf);
                if (cnf instanceof AnnotationAopConfigration) {
                    flag = false;
                }
                if (!(cnf instanceof ComboAopConfigration) || !((ComboAopConfigration)cnf).hasAnnotationAop()) continue;
                flag = false;
            }
            if (flag) {
                tmp.add(new AnnotationAopConfigration());
            }
            this.list = tmp;
        }
        ArrayList<InterceptorPair> interceptorPairs = new ArrayList<InterceptorPair>();
        for (AopConfigration cnf : this.list) {
            List<InterceptorPair> tmp = cnf.getInterceptorPairList(this.ioc, type);
            if (tmp == null) continue;
            interceptorPairs.addAll(tmp);
        }
        if (interceptorPairs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("%s , no config to enable AOP for this type.", type);
            }
            return Mirror.me(type);
        }
        Object object = lock;
        synchronized (object) {
            if (this.cd == null) {
                ClassLoader classLoader = type.getClassLoader();
                if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                log.info("Use as AOP ClassLoader parent : " + classLoader);
                DefaultClassDefiner.init(classLoader);
                this.cd = DefaultClassDefiner.defaultOne();
            }
            AsmClassAgent agent = new AsmClassAgent();
            for (InterceptorPair interceptorPair : interceptorPairs) {
                agent.addInterceptor(interceptorPair.getMethodMatcher(), interceptorPair.getMethodInterceptor());
            }
            return Mirror.me(agent.define(this.cd, type));
        }
    }

    @Deprecated
    public void setAopConfigration(AopConfigration aopConfigration) {
        this.list = new ArrayList<AopConfigration>();
        this.list.add(aopConfigration);
    }
}

