/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.arithmetic;

import java.util.LinkedList;
import java.util.Queue;
import org.nutz.el.Operator;
import org.nutz.el.opt.arithmetic.LBracketOpt;
import org.nutz.el.opt.arithmetic.RBracketOpt;
import org.nutz.el.opt.logic.QuestionOpt;
import org.nutz.el.opt.logic.QuestionSelectOpt;
import org.nutz.el.parse.Converter;

public class ShuntingYard {
    private LinkedList<Operator> opts;
    private Queue<Object> rpn;

    private void parseOperator(Operator current) {
        if (this.opts.isEmpty()) {
            this.opts.addFirst(current);
            return;
        }
        if (current instanceof LBracketOpt) {
            this.opts.addFirst(current);
            return;
        }
        if (current instanceof RBracketOpt) {
            while (!(this.opts.peek() instanceof LBracketOpt)) {
                this.rpn.add(this.opts.poll());
            }
            this.opts.poll();
            return;
        }
        if (!this.opts.isEmpty() && this.opts.peek().fetchPriority() > current.fetchPriority()) {
            this.opts.addFirst(current);
            return;
        }
        while (!(this.opts.isEmpty() || this.opts.peek().fetchPriority() > current.fetchPriority() || this.opts.peek() instanceof QuestionOpt && current instanceof QuestionOpt)) {
            if (this.opts.peek() instanceof QuestionOpt && current instanceof QuestionSelectOpt) {
                this.rpn.add(this.opts.poll());
                break;
            }
            this.rpn.add(this.opts.poll());
        }
        this.opts.addFirst(current);
    }

    public Queue<Object> parseToRPN(String val) {
        this.rpn = new LinkedList<Object>();
        this.opts = new LinkedList();
        Converter converter = new Converter(val);
        converter.initItems();
        while (!converter.isEnd()) {
            Object item = converter.fetchItem();
            if (item instanceof Operator) {
                this.parseOperator((Operator)item);
                continue;
            }
            this.rpn.add(item);
        }
        while (!this.opts.isEmpty()) {
            this.rpn.add(this.opts.poll());
        }
        return this.rpn;
    }
}

