/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DaoException;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Trans;
import org.nutz.trans.Transaction;

public class NutDaoRunner
implements DaoRunner {
    private static final Log log = Logs.get();

    @Override
    public void run(DataSource dataSource, ConnCallback callback) {
        Transaction t = Trans.get();
        if (null != t) {
            Connection conn = null;
            Savepoint sp = null;
            try {
                conn = t.getConnection(dataSource);
                sp = conn.setSavepoint();
                callback.invoke(conn);
            }
            catch (Exception e) {
                block27: {
                    if (e instanceof DaoException && null != conn && null != e.getCause() && e.getCause() instanceof SQLException) {
                        try {
                            if (null == sp) {
                                conn.rollback();
                            } else {
                                conn.rollback(sp);
                            }
                        }
                        catch (SQLException e1) {
                            if (!log.isErrorEnabled()) break block27;
                            log.error(e1);
                        }
                    }
                }
                throw new DaoException(Lang.unwrapThrow(e));
            }
        }
        Connection conn = null;
        boolean old = false;
        try {
            conn = dataSource.getConnection();
            old = conn.getAutoCommit();
            conn.setAutoCommit(false);
            callback.invoke(conn);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new DaoException(e);
        }
        finally {
            block30: {
                if (null != conn) {
                    block29: {
                        try {
                            if (old != conn.getAutoCommit()) {
                                conn.setAutoCommit(old);
                            }
                        }
                        catch (SQLException autoE) {
                            if (!log.isWarnEnabled()) break block29;
                            log.warn("Fail to restore autoCommet to '" + old + "'", autoE);
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException closeE) {
                        if (!log.isWarnEnabled()) break block30;
                        log.warn("Fail to close connection!", closeE);
                    }
                }
            }
        }
    }
}

