/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.dao.sql.VarIndex;
import org.nutz.lang.util.LinkedIntArray;

class VarIndexImpl
implements VarIndex {
    private Map<String, LinkedIntArray> indexes = new LinkedHashMap<String, LinkedIntArray>();
    private Map<Integer, String> names = new LinkedHashMap<Integer, String>();
    private ArrayList<String> orders = new ArrayList();

    VarIndexImpl() {
    }

    void add(String name, int index) {
        LinkedIntArray lia = this.indexes.get(name);
        if (null == lia) {
            lia = new LinkedIntArray();
            this.indexes.put(name, lia);
        }
        lia.push(index);
        this.names.put(index, name);
        this.orders.add(name);
    }

    Collection<LinkedIntArray> values() {
        return this.indexes.values();
    }

    @Override
    public int[] getOrderIndex(String name) {
        LinkedIntArray re = new LinkedIntArray(this.orders.size());
        int i = 0;
        for (String od : this.orders) {
            if (od.equals(name)) {
                re.push(i);
            }
            ++i;
        }
        return re.toArray();
    }

    @Override
    public List<String> getOrders() {
        return this.orders;
    }

    @Override
    public String getOrderName(int i) {
        return this.orders.get(i);
    }

    @Override
    public String nameOf(int i) {
        return this.names.get(i);
    }

    @Override
    public int[] indexesOf(String name) {
        LinkedIntArray lia = this.indexes.get(name);
        if (null == lia) {
            return null;
        }
        return lia.toArray();
    }

    @Override
    public Set<String> names() {
        return this.indexes.keySet();
    }

    @Override
    public int size() {
        return this.indexes.size();
    }
}

