/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.sqlite;

import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.impl.jdbc.mysql.MysqlJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;

public class SQLiteJdbcExpert
extends MysqlJdbcExpert {
    public SQLiteJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.SQLITE.name();
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        if (en.getPks().size() > 1 && en.getPkType() == PkType.ID) {
            return false;
        }
        boolean mPks = en.getPks().size() > 1;
        for (MappingField mf : en.getMappingFields()) {
            sb.append('\n').append(mf.getColumnName());
            if (mf.isId() && en.getPkType() == PkType.ID) {
                sb.append(" INTEGER PRIMARY KEY AUTOINCREMENT,");
                continue;
            }
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isUnsigned()) {
                    sb.append(" UNSIGNED");
                }
                if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                }
                if (mf.isPk() && !mPks) {
                    sb.append(" PRIMARY KEY");
                }
                if (mf.hasDefaultValue()) {
                    sb.append(" DEFAULT '").append(this.getDefaultValue(mf)).append('\'');
                }
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (mPks) {
            sb.append('\n');
            sb.append("constraint pk_").append(en.getTableName()).append(" PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnName()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        sb.setCharAt(sb.length() - 1, ')');
        dao.execute(Sqls.create(sb.toString()));
        this.createRelation(dao, en);
        return true;
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        String autoSql = "SELECT MAX($field) AS $field FROM $view";
        SqlFieldMacro autoInfo = new SqlFieldMacro(idField, autoSql);
        autoInfo.setEntity(en);
        return autoInfo;
    }
}

