/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.macro;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlType;
import org.nutz.lang.Lang;

public class SqlFieldMacro
extends NutPojo {
    private Sql sql;
    private MappingField entityField;

    private SqlFieldMacro() {
    }

    public SqlFieldMacro(MappingField field, String str) {
        this.entityField = field;
        this.sql = Sqls.create(str);
        this.setSqlType(this.sql.getSqlType());
        this.setEntity(field.getEntity());
    }

    @Override
    public Pojo setOperatingObject(Object obj) {
        super.setOperatingObject(obj);
        if (null != obj) {
            Entity<?> en = this.entityField.getEntity();
            if (!en.getType().isInstance(obj)) {
                throw Lang.makeThrow("Invalid operating object '%s' for field '%s'", obj.getClass().getName(), this.entityField.toString());
            }
            for (String name : this.sql.varIndex().names()) {
                if (name.equals("table") || name.equals("view") || name.equals("field")) continue;
                this.sql.vars().set(name, en.getField(name).getValue(obj));
            }
            for (String name : this.sql.paramIndex().names()) {
                this.sql.params().set(name, en.getField(name).getValue(obj));
            }
        }
        return this;
    }

    @Override
    public void onAfter(Connection conn, ResultSet rs) throws SQLException {
        if (rs.next()) {
            String colName = rs.getMetaData().getColumnName(1);
            Object obj = this.entityField.getAdaptor().get(rs, colName);
            this.entityField.setValue(this.getOperatingObject(), obj);
        }
    }

    @Override
    public SqlType getSqlType() {
        return this.sql.getSqlType();
    }

    @Override
    public ValueAdaptor[] getAdaptors() {
        return this.sql.getAdaptors();
    }

    @Override
    public Object[][] getParamMatrix() {
        return this.sql.getParamMatrix();
    }

    @Override
    public String toPreparedStatement() {
        return this._parseSQL(this.sql.duplicate()).toPreparedStatement();
    }

    @Override
    public Pojo duplicate() {
        SqlFieldMacro re = new SqlFieldMacro();
        re.sql = this.sql.duplicate();
        re.entityField = this.entityField;
        re.setSqlType(this.sql.getSqlType());
        re.setEntity(this.entityField.getEntity());
        return re;
    }

    private Sql _parseSQL(Sql sql) {
        for (String name : sql.varIndex().names()) {
            if ("view".equals(name)) {
                sql.vars().set("view", this.getEntity().getViewName());
                continue;
            }
            if ("table".equals(name)) {
                sql.vars().set("table", this.getEntity().getTableName());
                continue;
            }
            if ("field".equals(name)) {
                sql.vars().set("field", this.entityField.getColumnName());
                continue;
            }
            sql.vars().set(name, this.getEntity().getField(name).getValue(this.getOperatingObject()));
        }
        for (String name : sql.paramIndex().names()) {
            sql.params().set(name, this.getEntity().getField(name).getValue(this.getOperatingObject()));
        }
        return sql;
    }
}

