/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkType;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.field.AbstractLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class OneLinkField
extends AbstractLinkField {
    public OneLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info, Class<?> target, MappingField field, MappingField key) {
        super(entity, holder, info);
        this.targetType = target;
        this.hostField = field;
        this.linkedField = key;
    }

    public OneLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info) {
        super(entity, holder, info);
        this.targetType = info.one.target();
        this.hostField = entity.getField(info.one.field());
        if (null == this.hostField) {
            throw Lang.makeThrow("Invalid @One(field=%s) '%s' : %s<=>%s", info.one.field(), this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType());
        }
        if (!Strings.isBlank(info.one.key())) {
            this.linkedField = this.getLinkedEntity().getField(info.one.key());
            if (this.linkedField == null) {
                throw Lang.makeThrow("Fail to find linkedField for @One(field=%s) '%s' : %s<=>%s By key=%s", info.one.field(), this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType(), info.one.key());
            }
            return;
        }
        MappingField mappingField = this.linkedField = this.hostField.getTypeMirror().isIntLike() ? this.getLinkedEntity().getIdField() : this.getLinkedEntity().getNameField();
        if (null == this.linkedField) {
            throw Lang.makeThrow("Fail to find linkedField for @One(field=%s) '%s' : %s<=>%s By %s", info.one.field(), this.getName(), this.getEntity().getType(), this.getLinkedEntity().getType(), this.hostField.getTypeMirror().isIntLike() ? "@Id" : "@Name");
        }
    }

    @Override
    public Condition createCondition(Object host) {
        return Cnd.where(this.linkedField.getColumnName(), "=", this.hostField.getValue(host));
    }

    @Override
    public void updateLinkedField(Object obj, Object linked) {
    }

    @Override
    public void saveLinkedField(Object obj, Object linked) {
        Object v = this.linkedField.getValue(linked);
        this.hostField.setValue(obj, v);
    }

    @Override
    public LinkType getLinkType() {
        return LinkType.ONE;
    }
}

