/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.SqlManager;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.AnnotationEntityMaker;
import org.nutz.dao.impl.sql.NutPojoMaker;
import org.nutz.dao.impl.sql.run.NutDaoExecutor;
import org.nutz.dao.impl.sql.run.NutDaoRunner;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.PojoMaker;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlContext;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;

public class DaoSupport {
    private static final Log log = Logs.get();
    protected DaoRunner runner = new NutDaoRunner();
    protected DaoExecutor executor = new NutDaoExecutor();
    protected DataSource dataSource;
    protected JdbcExpert expert;
    protected PojoMaker pojoMaker;
    protected EntityHolder holder;
    private DatabaseMeta meta;
    private SqlManager sqlManager;

    public SqlManager sqls() {
        return this.sqlManager;
    }

    public DatabaseMeta meta() {
        return this.meta;
    }

    public void setSqlManager(SqlManager sqls) {
        this.sqlManager = sqls;
    }

    public void setRunner(DaoRunner runner) {
        this.runner = runner;
    }

    public void setExecutor(DaoExecutor executor) {
        this.executor = executor;
    }

    public void setPojoMaker(PojoMaker pojoMaker) {
        this.pojoMaker = pojoMaker;
    }

    public JdbcExpert getJdbcExpert() {
        return this.expert;
    }

    public void setDataSource(DataSource ds) {
        if (null != this.dataSource && log.isWarnEnabled()) {
            log.warn("Replaced a running dataSource!");
        }
        this.dataSource = ds;
        if (this.expert == null) {
            this.expert = Jdbcs.getExpert(ds);
        }
        this.pojoMaker = new NutPojoMaker(this.expert);
        this.meta = new DatabaseMeta();
        this.runner.run(this.dataSource, new ConnCallback(){

            @Override
            public void invoke(Connection conn) throws Exception {
                DatabaseMetaData dmd = conn.getMetaData();
                DaoSupport.this.meta.setProductName(dmd.getDatabaseProductName());
                DaoSupport.this.meta.setVersion(dmd.getDatabaseProductVersion());
                log.debug("JDBC Driver --> " + dmd.getDriverVersion());
                log.debug("JDBC Name   --> " + dmd.getDriverName());
                if (dmd.getDriverName().contains("mariadb") || dmd.getDriverName().contains("sqlite")) {
                    log.warn("Auto-select fetch size to Integer.MIN_VALUE, enable for ResultSet Streaming");
                    SqlContext.DEFAULT_FETCH_SIZE = Integer.MIN_VALUE;
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Database info --> " + this.meta);
        }
        this.holder = new EntityHolder(this);
        this.holder.maker = this.createEntityMaker();
    }

    public void execute(Sql ... sqls) {
        for (Sql sql : sqls) {
            this.expert.formatQuery(sql);
        }
        this._exec(sqls);
    }

    public void run(ConnCallback callback) {
        this.runner.run(this.dataSource, callback);
    }

    protected int _exec(DaoStatement ... sts) {
        boolean isAllSelect = true;
        for (DaoStatement st : sts) {
            if (st.isSelect()) continue;
            isAllSelect = false;
            break;
        }
        DaoExec callback = new DaoExec(sts);
        if (sts.length == 1 || isAllSelect || Trans.isTransactionNone()) {
            this.runner.run(this.dataSource, callback);
        } else {
            Trans.exec(callback);
        }
        return callback.re;
    }

    protected EntityMaker createEntityMaker() {
        return new AnnotationEntityMaker(this.dataSource, this.expert, this.holder);
    }

    public PojoMaker pojoMaker() {
        return this.pojoMaker;
    }

    protected class DaoExec
    implements Atom,
    ConnCallback {
        private DaoStatement[] sts;
        private int re;

        public DaoExec(DaoStatement ... sts) {
            this.sts = sts;
        }

        @Override
        public void run() {
            DaoSupport.this.runner.run(DaoSupport.this.dataSource, this);
        }

        @Override
        public void invoke(Connection conn) throws Exception {
            for (DaoStatement st : this.sts) {
                if (st == null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("Found a null DaoStatement(SQL), ingore it ~~");
                    continue;
                }
                DaoSupport.this.executor.exec(conn, st);
                this.re += st.getUpdateCount();
            }
        }
    }
}

