/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.ssl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

final class CertificateTool {
    public static void loadX509Cert(List<File> certFiles, KeyStore keyStore) throws GeneralSecurityException, IOException {
        int certCount = 0;
        for (File certFile : certFiles) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(certFile));){
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                while (inputStream.available() > 0) {
                    try {
                        Certificate cert = certFactory.generateCertificate(inputStream);
                        CertificateTool.loadX509Cert(cert, "neo4j.javadriver.trustedcert." + ++certCount, keyStore);
                    }
                    catch (CertificateException e) {
                        if (e.getCause() != null && e.getCause().getMessage().equals("Empty input")) {
                            inputStream.close();
                            return;
                        }
                        throw new IOException("Failed to load certificate from `" + certFile.getAbsolutePath() + "`: " + certCount + " : " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    public static void loadX509Cert(X509Certificate[] certificates, KeyStore keyStore) throws GeneralSecurityException {
        for (int i = 0; i < certificates.length; ++i) {
            CertificateTool.loadX509Cert(certificates[i], "neo4j.javadriver.trustedcert." + i, keyStore);
        }
    }

    private static void loadX509Cert(Certificate cert, String certAlias, KeyStore keyStore) throws KeyStoreException {
        keyStore.setCertificateEntry(certAlias, cert);
    }

    private CertificateTool() {
    }
}

