/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;

public class KotlinFunctionParts {
    private List<String> annotations;
    private List<String> codeLines;
    private Set<String> imports;
    private List<KotlinArg> arguments;

    private KotlinFunctionParts(Builder builder) {
        this.imports = builder.imports;
        this.codeLines = builder.codeLines;
        this.arguments = builder.arguments;
        this.annotations = builder.annotations;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<String> getCodeLines() {
        return this.codeLines;
    }

    public List<KotlinArg> getArguments() {
        return this.arguments;
    }

    public static class Builder {
        private List<String> codeLines = new ArrayList<String>();
        private Set<String> imports = new HashSet<String>();
        private List<KotlinArg> arguments = new ArrayList<KotlinArg>();
        private List<String> annotations = new ArrayList<String>();

        public Builder withAnnotation(String annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public Builder withCodeLine(String codeLine) {
            this.codeLines.add(codeLine);
            return this;
        }

        public Builder withBodyLines(List<String> codeLines) {
            this.codeLines.addAll(codeLines);
            return this;
        }

        public Builder withImport(String im) {
            this.imports.add(im);
            return this;
        }

        public Builder withImports(Set<String> imports) {
            this.imports.addAll(imports);
            return this;
        }

        public Builder withArgument(KotlinArg argument) {
            this.arguments.add(argument);
            return this;
        }

        public KotlinFunctionParts build() {
            return new KotlinFunctionParts(this);
        }
    }
}

