/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;

public class InsertSelectiveMethodGenerator
extends AbstractKotlinFunctionGenerator {
    private FullyQualifiedKotlinType recordType;
    private String mapperName;
    private String tableFieldImport;

    private InsertSelectiveMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.mapperName = builder.mapperName;
        this.tableFieldImport = builder.tableFieldImport;
    }

    @Override
    public KotlinFunctionAndImports generateMethodAndImports() {
        KotlinFunctionAndImports functionAndImports = KotlinFunctionAndImports.withFunction(KotlinFunction.newOneLineFunction(this.mapperName + ".insertSelective").withArgument(KotlinArg.newArg("record").withDataType(this.recordType.getShortNameWithTypeArguments()).build()).build()).withImport("org.mybatis.dynamic.sql.util.kotlin.mybatis3.*").withImports(this.recordType.getImportList()).build();
        this.addFunctionComment(functionAndImports);
        KotlinFunction function = functionAndImports.getFunction();
        function.addCodeLine("insert(this::insert, record, " + this.tableFieldName + ") {");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        for (IntrospectedColumn column : columns) {
            String fieldName = column.getJavaProperty();
            functionAndImports.getImports().add(this.tableFieldImport + "." + fieldName);
            if (column.isSequenceColumn()) {
                function.addCodeLine("    map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
                continue;
            }
            function.addCodeLine("    map(" + fieldName + ").toPropertyWhenPresent(\"" + column.getJavaProperty() + "\", record::" + fieldName + ")");
        }
        function.addCodeLine("}");
        return functionAndImports;
    }

    @Override
    public boolean callPlugins(KotlinFunction kotlinFunction, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientInsertSelectiveMethodGenerated(kotlinFunction, kotlinFile, this.introspectedTable);
    }

    public static class Builder
    extends AbstractKotlinFunctionGenerator.BaseBuilder<Builder, InsertSelectiveMethodGenerator> {
        private FullyQualifiedKotlinType recordType;
        private String mapperName;
        private String tableFieldImport;

        public Builder withRecordType(FullyQualifiedKotlinType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withMapperName(String mapperName) {
            this.mapperName = mapperName;
            return this;
        }

        public Builder withTableFieldImport(String tableFieldImport) {
            this.tableFieldImport = tableFieldImport;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public InsertSelectiveMethodGenerator build() {
            return new InsertSelectiveMethodGenerator(this);
        }
    }
}

