/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.dynamic.sql.elements.v2.Utils;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;

public class InsertMultipleMethodGenerator
extends AbstractKotlinFunctionGenerator {
    private FullyQualifiedKotlinType recordType;
    private String mapperName;
    private String tableFieldImport;

    private InsertMultipleMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.mapperName = builder.mapperName;
        this.tableFieldImport = builder.tableFieldImport;
    }

    @Override
    public KotlinFunctionAndImports generateMethodAndImports() {
        if (!Utils.generateMultipleRowInsert(this.introspectedTable)) {
            return null;
        }
        String mapperMethod = Utils.generateMultipleRowInsertHelper(this.introspectedTable) ? "insertMultipleHelper" : "insertMultiple";
        KotlinFunctionAndImports functionAndImports = KotlinFunctionAndImports.withFunction(KotlinFunction.newOneLineFunction(this.mapperName + ".insertMultiple").withArgument(KotlinArg.newArg("records").withDataType("Collection<" + this.recordType.getShortNameWithTypeArguments() + ">").build()).build()).withImport("org.mybatis.dynamic.sql.util.kotlin.mybatis3.*").withImports(this.recordType.getImportList()).build();
        this.addFunctionComment(functionAndImports);
        KotlinFunction function = functionAndImports.getFunction();
        function.addCodeLine("insertMultiple(this::" + mapperMethod + ", records, " + this.tableFieldName + ") {");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        for (IntrospectedColumn column : columns) {
            String fieldName = column.getJavaProperty();
            functionAndImports.getImports().add(this.tableFieldImport + "." + fieldName);
            function.addCodeLine("    map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
        }
        function.addCodeLine("}");
        return functionAndImports;
    }

    @Override
    public boolean callPlugins(KotlinFunction kotlinFunction, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientInsertMultipleMethodGenerated(kotlinFunction, kotlinFile, this.introspectedTable);
    }

    public static class Builder
    extends AbstractKotlinFunctionGenerator.BaseBuilder<Builder, InsertMultipleMethodGenerator> {
        private FullyQualifiedKotlinType recordType;
        private String mapperName;
        private String tableFieldImport;

        public Builder withRecordType(FullyQualifiedKotlinType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withMapperName(String mapperName) {
            this.mapperName = mapperName;
            return this;
        }

        public Builder withTableFieldImport(String tableFieldImport) {
            this.tableFieldImport = tableFieldImport;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public InsertMultipleMethodGenerator build() {
            return new InsertMultipleMethodGenerator(this);
        }
    }
}

