/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinModifier;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.runtime.kotlin.elements.KotlinPropertyAndImports;

public class ColumnListGenerator {
    private Context context;
    private IntrospectedTable introspectedTable;
    private String tableFieldImport;

    private ColumnListGenerator(Builder builder) {
        this.context = Objects.requireNonNull(builder.context);
        this.introspectedTable = Objects.requireNonNull(builder.introspectedTable);
        this.tableFieldImport = Objects.requireNonNull(builder.tableFieldImport);
    }

    public KotlinPropertyAndImports generatePropertyAndImports() {
        KotlinPropertyAndImports propertyAndImports = KotlinPropertyAndImports.withProperty(((KotlinProperty.Builder)KotlinProperty.newVal("columnList").withModifier(KotlinModifier.PRIVATE)).withInitializationString(this.getInitializationString()).build()).withImports(this.getImports()).build();
        this.context.getCommentGenerator().addGeneralPropertyComment(propertyAndImports.getProperty(), this.introspectedTable, propertyAndImports.getImports());
        return propertyAndImports;
    }

    private String getInitializationString() {
        return this.introspectedTable.getAllColumns().stream().map(IntrospectedColumn::getJavaProperty).collect(Collectors.joining(", ", "listOf(", ")"));
    }

    private Set<String> getImports() {
        return this.introspectedTable.getAllColumns().stream().map(c -> this.tableFieldImport + "." + c.getJavaProperty()).collect(Collectors.toSet());
    }

    public boolean callPlugins(KotlinProperty kotlinProperty, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientColumnListPropertyGenerated(kotlinProperty, kotlinFile, this.introspectedTable);
    }

    public static class Builder {
        private Context context;
        private IntrospectedTable introspectedTable;
        private String tableFieldImport;

        public Builder withTableFieldImport(String tableFieldImport) {
            this.tableFieldImport = tableFieldImport;
            return this;
        }

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this;
        }

        public ColumnListGenerator build() {
            return new ColumnListGenerator(this);
        }
    }
}

