/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin;

import java.util.List;
import java.util.Objects;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.JavaToKotlinTypeConverter;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;

public class KotlinDynamicSqlSupportClassGenerator {
    private IntrospectedTable introspectedTable;
    private Context context;
    private KotlinFile kotlinFile;
    private KotlinType innerObject;
    private KotlinType outerObject;

    public KotlinDynamicSqlSupportClassGenerator(Context context, IntrospectedTable introspectedTable) {
        this.introspectedTable = Objects.requireNonNull(introspectedTable);
        this.context = Objects.requireNonNull(context);
        this.generate();
    }

    private void generate() {
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getMyBatisDynamicSqlSupportType());
        this.kotlinFile = this.buildBasicFile(type);
        this.outerObject = this.buildOuterObject(this.kotlinFile, type);
        this.innerObject = this.buildInnerObject();
        this.outerObject.addNamedItem(this.innerObject);
        List<IntrospectedColumn> columns = this.introspectedTable.getAllColumns();
        for (IntrospectedColumn column : columns) {
            this.handleColumn(this.kotlinFile, this.innerObject, column);
        }
    }

    public KotlinFile getKotlinFile() {
        return this.kotlinFile;
    }

    public KotlinType getInnerObject() {
        return this.innerObject;
    }

    public String getInnerObjectImport() {
        return this.kotlinFile.getPackage().map(s -> s + ".").orElse("") + this.outerObject.getName() + "." + this.innerObject.getName();
    }

    private KotlinFile buildBasicFile(FullyQualifiedJavaType type) {
        KotlinFile kf = new KotlinFile(type.getShortNameWithoutTypeArguments());
        kf.setPackage(type.getPackageName());
        this.context.getCommentGenerator().addFileComment(kf);
        return kf;
    }

    private KotlinType buildOuterObject(KotlinFile kotlinFile, FullyQualifiedJavaType type) {
        KotlinType outerObject = KotlinType.newObject(type.getShortNameWithoutTypeArguments()).build();
        kotlinFile.addImport("org.mybatis.dynamic.sql.SqlTable");
        kotlinFile.addImport("java.sql.JDBCType");
        kotlinFile.addNamedItem(outerObject);
        return outerObject;
    }

    private KotlinType buildInnerObject() {
        String domainObjectName = this.introspectedTable.getFullyQualifiedTable().getDomainObjectName();
        return KotlinType.newObject(domainObjectName).withSuperType("SqlTable(\"" + StringUtility.escapeStringForKotlin(this.introspectedTable.getFullyQualifiedTableNameAtRuntime()) + "\")").build();
    }

    private void handleColumn(KotlinFile kotlinFile, KotlinType kotlinType, IntrospectedColumn column) {
        FullyQualifiedKotlinType kt = JavaToKotlinTypeConverter.convert(column.getFullyQualifiedJavaType());
        kotlinFile.addImports(kt.getImportList());
        String fieldName = column.getJavaProperty();
        KotlinProperty property = KotlinProperty.newVal(fieldName).withInitializationString(this.calculateInnerInitializationString(column, kt)).build();
        kotlinType.addNamedItem(property);
    }

    private String calculateInnerInitializationString(IntrospectedColumn column, FullyQualifiedKotlinType kt) {
        StringBuilder initializationString = new StringBuilder();
        initializationString.append(String.format("column<%s>(\"%s\", JDBCType.%s", kt.getShortNameWithTypeArguments(), StringUtility.escapeStringForKotlin(MyBatis3FormattingUtilities.getEscapedColumnName(column)), column.getJdbcTypeName()));
        if (StringUtility.stringHasValue(column.getTypeHandler())) {
            initializationString.append(String.format(", \"%s\")", column.getTypeHandler()));
        } else {
            initializationString.append(')');
        }
        return initializationString.toString();
    }
}

