/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements.v2;

import java.util.HashSet;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.v2.Utils;

public class InsertMultipleMethodGenerator
extends AbstractMethodGenerator {
    private FullyQualifiedJavaType recordType;

    private InsertMultipleMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!Utils.generateMultipleRowInsert(this.introspectedTable)) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils"));
        imports.add(this.recordType);
        Method method = new Method("insertMultiple");
        method.setDefault(true);
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("java.util.Collection");
        parameterType.addTypeArgument(this.recordType);
        imports.add(parameterType);
        method.addParameter(new Parameter(parameterType, "records"));
        method.addBodyLine("return MyBatis3Utils.insertMultiple(this::insertMultiple, records, " + this.tableFieldName + ", c ->");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        boolean first = true;
        for (IntrospectedColumn column : columns) {
            String fieldName = this.calculateFieldName(column);
            if (first) {
                method.addBodyLine("    c.map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
                first = false;
                continue;
            }
            method.addBodyLine("    .map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
        }
        method.addBodyLine(");");
        return MethodAndImports.withMethod(method).withImports(imports).build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return this.context.getPlugins().clientInsertMultipleMethodGenerated(method, interfaze, this.introspectedTable);
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder, InsertMultipleMethodGenerator> {
        private FullyQualifiedJavaType recordType;

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public InsertMultipleMethodGenerator build() {
            return new InsertMultipleMethodGenerator(this);
        }
    }
}

